/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.highlight;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedTerm;

public class QueryTermExtractor {
    private static WeightedTerm[] _emptyWeightedTermArray = new WeightedTerm[0];
    private static CopyOnWriteArrayList<Class<? extends Query>> _queryClasses = new CopyOnWriteArrayList();

    public static WeightedTerm[] getTerms(Query query, boolean prohibited, String fieldName) {
        if (query == null) {
            return _emptyWeightedTermArray;
        }
        HashSet<WeightedTerm> weightedTerms = new HashSet<WeightedTerm>();
        HashSet terms = new HashSet();
        LinkedList<Query> queries = new LinkedList<Query>();
        Query lastQuery = query;
        while (lastQuery != null) {
            if (lastQuery instanceof BooleanQuery) {
                BooleanClause[] booleanClauses;
                BooleanQuery booleanQuery = (BooleanQuery)lastQuery;
                for (BooleanClause booleanClause : booleanClauses = booleanQuery.getClauses()) {
                    Query booleanClauseQuery;
                    if (!prohibited && booleanClause.getOccur() == BooleanClause.Occur.MUST_NOT || (booleanClauseQuery = booleanClause.getQuery()) == null) continue;
                    queries.addFirst(booleanClauseQuery);
                }
                lastQuery = (Query)queries.poll();
                continue;
            }
            if (lastQuery instanceof FilteredQuery) {
                FilteredQuery filteredQuery = (FilteredQuery)lastQuery;
                if ((lastQuery = filteredQuery.getQuery()) != null) continue;
                lastQuery = (Query)queries.poll();
                continue;
            }
            Class<?> queryClass = lastQuery.getClass();
            if (!_queryClasses.contains(queryClass)) {
                try {
                    lastQuery.extractTerms(terms);
                    for (Term term : terms) {
                        if (fieldName != null && !fieldName.equals(term.field())) continue;
                        WeightedTerm weightedTerm = new WeightedTerm(query.getBoost(), term.text());
                        weightedTerms.add(weightedTerm);
                    }
                    terms.clear();
                }
                catch (UnsupportedOperationException uoe) {
                    _queryClasses.addIfAbsent(queryClass);
                }
            }
            lastQuery = (Query)queries.poll();
        }
        return weightedTerms.toArray(new WeightedTerm[weightedTerms.size()]);
    }
}

