/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.dump;

import com.liferay.portal.kernel.util.StringBundler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.Directory;

public class IndexCommitMetaInfo
implements Serializable {
    private boolean _empty;
    private long _generation;
    private List<Segment> _segments;

    public IndexCommitMetaInfo(IndexCommit indexCommit) throws IOException {
        if (indexCommit == null) {
            this._empty = true;
            return;
        }
        ArrayList fileNames = new ArrayList(indexCommit.getFileNames());
        this._segments = new ArrayList<Segment>(fileNames.size());
        Directory directory = indexCommit.getDirectory();
        for (String fileName : fileNames) {
            Segment segment = new Segment(fileName, directory.fileLength(fileName));
            this._segments.add(segment);
        }
        this._generation = indexCommit.getGeneration();
    }

    public long getGeneration() {
        return this._generation;
    }

    public List<Segment> getSegments() {
        return this._segments;
    }

    public boolean isEmpty() {
        return this._empty;
    }

    public String toString() {
        if (this._empty) {
            return "";
        }
        StringBundler sb = new StringBundler(this._segments.size() * 5 + 3);
        sb.append("{fileInfos[");
        for (int i = 0; i < this._segments.size(); ++i) {
            Segment fileInfo = this._segments.get(i);
            sb.append("fileName=");
            sb.append(fileInfo._fileName);
            sb.append(", fileSize=");
            sb.append(fileInfo._fileSize);
            if (i + 1 >= this._segments.size()) continue;
            sb.append(", ");
        }
        sb.append("], generation=");
        sb.append(this._generation);
        sb.append("}");
        return sb.toString();
    }

    public class Segment
    implements Serializable {
        private String _fileName;
        private long _fileSize;

        public Segment(String fileName, long fileSize) {
            this._fileName = fileName;
            this._fileSize = fileSize;
        }

        public String getFileName() {
            return this._fileName;
        }

        public long getFileSize() {
            return this._fileSize;
        }

        public String toString() {
            StringBundler sb = new StringBundler(5);
            sb.append("{_fileName=");
            sb.append(this._fileName);
            sb.append(", _fileSize=");
            sb.append(this._fileSize);
            sb.append("}");
            return sb.toString();
        }
    }
}

