/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene.cluster;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import java.io.IOException;
import java.io.InputStream;

public class LuceneClusterUtil {
    private static Log _log = LogFactoryUtil.getLog(LuceneClusterUtil.class);

    public static void loadIndexesFromCluster(long companyId) {
        LuceneHelperUtil.loadIndexesFromCluster(companyId);
    }

    public static void loadIndexesFromCluster(long[] companyIds, Address bootupAddress) {
        if (bootupAddress == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Start loading Lucene index files from cluster node " + bootupAddress));
        }
        InputStream inputStream = null;
        for (long companyId : companyIds) {
            try {
                inputStream = LuceneHelperUtil.getLoadIndexesInputStreamFromCluster(companyId, bootupAddress);
                LuceneHelperUtil.loadIndex(companyId, inputStream);
            }
            catch (SystemException se) {
                throw se;
            }
            catch (IOException ioe) {
                throw new SystemException((Throwable)ioe);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        throw new SystemException((Throwable)ioe);
                    }
                }
            }
        }
    }
}

