/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.exception.LoggedExceptionInInitializerError;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.QueryTranslator;
import com.liferay.portal.kernel.search.StringQueryImpl;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.BooleanQueryImpl;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneQueryImpl;
import com.liferay.portal.search.lucene.TermQueryImpl;
import com.liferay.portal.search.lucene.TermRangeQueryImpl;
import java.lang.reflect.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

@DoPrivileged
public class QueryTranslatorImpl
implements QueryTranslator {
    private static final Field _TEXT_FIELD;
    private static Log _log;

    public Object translate(com.liferay.portal.kernel.search.Query query) throws ParseException {
        if (query instanceof BooleanQueryImpl) {
            return ((BooleanQueryImpl)query).getBooleanQuery();
        }
        if (query instanceof LuceneQueryImpl) {
            return ((LuceneQueryImpl)query).getQuery();
        }
        if (query instanceof StringQueryImpl) {
            QueryParser queryParser = new QueryParser(LuceneHelperUtil.getVersion(), "", LuceneHelperUtil.getAnalyzer());
            try {
                return queryParser.parse(query.toString());
            }
            catch (org.apache.lucene.queryParser.ParseException pe) {
                throw new ParseException((Throwable)pe);
            }
        }
        if (query instanceof TermQueryImpl) {
            return ((TermQueryImpl)query).getTermQuery();
        }
        if (query instanceof TermRangeQueryImpl) {
            return ((TermRangeQueryImpl)query).getTermRangeQuery();
        }
        return null;
    }

    public Object translateForSolr(com.liferay.portal.kernel.search.Query query) {
        Object queryObject = query.getWrappedQuery();
        if (queryObject instanceof Query) {
            this.adjustQuery((Query)queryObject);
        }
        return query;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void adjustQuery(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause booleanClause : booleanQuery.getClauses()) {
                this.adjustQuery(booleanClause.getQuery());
            }
            return;
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            Term term = termQuery.getTerm();
            try {
                String text = term.text();
                if (!text.matches("^\\s*[^\"].*\\s+.*[^\"]\\s*$(?m)")) return;
                text = "\"".concat(text).concat("\"");
                _TEXT_FIELD.set(term, text);
                return;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            return;
        } else {
            if (!(query instanceof WildcardQuery)) return;
            WildcardQuery wildcardQuery = (WildcardQuery)query;
            Term term = wildcardQuery.getTerm();
            try {
                String text = term.text();
                if (Validator.equals((Object)term.field(), (Object)"treePath")) {
                    text = text.replaceAll("/", "\\\\/");
                }
                if (!text.matches("^\\s*\\*.*(?m)")) return;
                text = text.replaceFirst("\\*", "");
                _TEXT_FIELD.set(term, text);
                return;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    static {
        _log = LogFactoryUtil.getLog(QueryTranslatorImpl.class);
        try {
            _TEXT_FIELD = Term.class.getDeclaredField("text");
            _TEXT_FIELD.setAccessible(true);
        }
        catch (Exception e) {
            throw new LoggedExceptionInInitializerError((Throwable)e);
        }
    }
}

