/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Tokenizer;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Fieldable;

public class PerFieldAnalyzer
extends Analyzer
implements Tokenizer {
    private static Log _log = LogFactoryUtil.getLog(PerFieldAnalyzer.class);
    private Analyzer _analyzer;
    private Map<String, ObjectValuePair<Pattern, Analyzer>> _analyzers = new LinkedHashMap<String, ObjectValuePair<Pattern, Analyzer>>();

    public PerFieldAnalyzer(Analyzer defaultAnalyzer, Map<String, Analyzer> analyzerMap) {
        this._analyzer = defaultAnalyzer;
        for (Map.Entry<String, Analyzer> entry : analyzerMap.entrySet()) {
            this.addAnalyzer(entry.getKey(), entry.getValue());
        }
    }

    public void addAnalyzer(String fieldName, Analyzer analyzer) {
        this._analyzers.put(fieldName, (ObjectValuePair<Pattern, Analyzer>)new ObjectValuePair((Object)Pattern.compile(fieldName), (Object)analyzer));
    }

    public Analyzer getAnalyzer(String fieldName) {
        ObjectValuePair<Pattern, Analyzer> objectValuePair = this._analyzers.get(fieldName);
        if (objectValuePair != null) {
            return (Analyzer)objectValuePair.getValue();
        }
        for (ObjectValuePair<Pattern, Analyzer> curObjectValuePair : this._analyzers.values()) {
            Pattern pattern = (Pattern)curObjectValuePair.getKey();
            Matcher matcher = pattern.matcher(fieldName);
            if (!matcher.matches()) continue;
            return (Analyzer)curObjectValuePair.getValue();
        }
        return this._analyzer;
    }

    public int getOffsetGap(Fieldable field) {
        Analyzer analyzer = this.getAnalyzer(field.name());
        return analyzer.getOffsetGap(field);
    }

    public int getPositionIncrementGap(String fieldName) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.getPositionIncrementGap(fieldName);
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.reusableTokenStream(fieldName, reader);
    }

    public List<String> tokenize(String fieldName, String input, String languageId) throws SearchException {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream tokenStream = null;
        try {
            String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)fieldName);
            Analyzer analyzer = this.getAnalyzer(localizedFieldName);
            tokenStream = analyzer.tokenStream(localizedFieldName, (Reader)new StringReader(input));
            CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                tokens.add(charTermAttribute.toString());
            }
            tokenStream.end();
        }
        catch (IOException ioe) {
            throw new SearchException((Throwable)ioe);
        }
        finally {
            block12: {
                if (tokenStream != null) {
                    try {
                        tokenStream.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Object)"Unable to close token stream", (Throwable)ioe);
                    }
                }
            }
        }
        return tokens;
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyzer = this.getAnalyzer(fieldName);
        return analyzer.tokenStream(fieldName, reader);
    }
}

