/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.search.BaseSearchEngine;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class LuceneSearchEngine
extends BaseSearchEngine {
    public synchronized String backup(long companyId, String backupName) {
        String string;
        FileOutputStream fileOutputStream = null;
        try {
            String fileName = this.getFileName(backupName);
            fileOutputStream = new FileOutputStream(fileName);
            LuceneHelperUtil.dumpIndex(companyId, fileOutputStream);
            string = fileName;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{fileOutputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileOutputStream});
        return string;
    }

    public void initialize(long companyId) {
        super.initialize(companyId);
        LuceneHelperUtil.startup(companyId);
    }

    public synchronized void removeBackup(long companyId, String backupName) {
        String fileName = this.getFileName(backupName);
        FileUtil.delete((String)fileName);
    }

    public void removeCompany(long companyId) {
        super.removeCompany(companyId);
        LuceneHelperUtil.delete(companyId);
        LuceneHelperUtil.shutdown(companyId);
    }

    public synchronized void restore(long companyId, String backupName) {
        FileInputStream fileInputStream = null;
        try {
            String fileName = this.getFileName(backupName);
            fileInputStream = new FileInputStream(fileName);
            LuceneHelperUtil.loadIndex(companyId, fileInputStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
                throw throwable;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
    }

    protected String getFileName(String backupName) {
        return SystemProperties.get((String)"java.io.tmpdir") + File.separator + backupName;
    }
}

