/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BoboSubBrowser;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseResult;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTranslatorUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;

public class LuceneIndexSearcher
extends BaseIndexSearcher {
    private static Log _log = LogFactoryUtil.getLog(LuceneIndexSearcher.class);
    private static Field _runtimeFacetDataMapField;
    private static Field _runtimeFacetHandlerMapField;

    /*
     * Exception decompiling
     */
    public Hits search(SearchContext searchContext, com.liferay.portal.kernel.search.Query query) throws SearchException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void cleanUp(BoboBrowser boboBrowser) {
        Browsable[] browsables;
        if (boboBrowser == null) {
            return;
        }
        try {
            boboBrowser.close();
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
        for (Browsable browsable : browsables = boboBrowser.getSubBrowsers()) {
            ThreadLocal threadLocal;
            if (!(browsable instanceof BoboSubBrowser)) continue;
            BoboSubBrowser boboSubBrowser = (BoboSubBrowser)browsable;
            BoboIndexReader boboIndexReader = boboSubBrowser.getIndexReader();
            try {
                threadLocal = (ThreadLocal)_runtimeFacetDataMapField.get(boboIndexReader);
                threadLocal.remove();
                _runtimeFacetDataMapField.set(boboIndexReader, null);
            }
            catch (Exception e) {
                _log.error((Object)"Unable to clean up BoboIndexReader#_runtimeFacetDataMap", (Throwable)e);
            }
            try {
                threadLocal = (ThreadLocal)_runtimeFacetHandlerMapField.get(boboIndexReader);
                threadLocal.remove();
                _runtimeFacetHandlerMapField.set(boboIndexReader, null);
            }
            catch (Exception e) {
                _log.error((Object)"Unable to clean up BoboIndexReader#_runtimeFacetHandlerMap", (Throwable)e);
            }
        }
    }

    protected DocumentImpl getDocument(org.apache.lucene.document.Document oldDocument) {
        DocumentImpl newDocument = new DocumentImpl();
        List oldFieldables = oldDocument.getFields();
        for (Fieldable oldFieldable : oldFieldables) {
            com.liferay.portal.kernel.search.Field newField = null;
            String[] values = oldDocument.getValues(oldFieldable.name());
            newField = values != null && values.length > 1 ? new com.liferay.portal.kernel.search.Field(oldFieldable.name(), values) : new com.liferay.portal.kernel.search.Field(oldFieldable.name(), oldFieldable.stringValue());
            newField.setNumeric(oldFieldable instanceof NumericField);
            newField.setTokenized(oldFieldable.isTokenized());
            newDocument.add(newField);
        }
        return newDocument;
    }

    protected Set<String> getQueryTerms(com.liferay.portal.kernel.search.Query query) {
        HashSet<String> queryTerms = new HashSet();
        try {
            queryTerms = LuceneHelperUtil.getQueryTerms((Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query));
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        return queryTerms;
    }

    protected String getSnippet(org.apache.lucene.document.Document doc, com.liferay.portal.kernel.search.Query query, String field, Locale locale, Document hitDoc, Set<String> matchingTerms) throws IOException {
        String snippetField = DocumentImpl.getLocalizedName((Locale)locale, (String)field);
        String snippet = null;
        try {
            Query luceneQuery = (Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query);
            Object[] values = doc.getValues(snippetField);
            TermCollectingFormatter termCollectingFormatter = new TermCollectingFormatter();
            if (ArrayUtil.isNotEmpty((Object[])values)) {
                snippet = LuceneHelperUtil.getSnippet(luceneQuery, snippetField, StringUtil.merge((Object[])values), termCollectingFormatter);
            }
            if (ArrayUtil.isEmpty((Object[])values) || Validator.isNull(snippet)) {
                snippetField = field;
                values = doc.getValues(snippetField);
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return "";
                }
                snippet = LuceneHelperUtil.getSnippet(luceneQuery, field, StringUtil.merge((Object[])values), termCollectingFormatter);
            }
            if (Validator.isNull((String)snippet)) {
                return "";
            }
            matchingTerms.addAll(termCollectingFormatter.getTerms());
        }
        catch (ParseException pe) {
            _log.error((Object)("Query " + query), (Throwable)pe);
        }
        hitDoc.addText("snippet".concat("_").concat(snippetField), snippet);
        return snippet;
    }

    protected Hits toHits(IndexSearcher indexSearcher, BrowseResult browseResult, com.liferay.portal.kernel.search.Query query, long startTime, float searchTime, int start, int end) throws IOException, ParseException {
        int total = browseResult.getNumHits();
        BrowseHit[] browseHits = browseResult.getHits();
        if (start == -1 && end == -1) {
            start = 0;
            end = total;
        }
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)total);
        start = startAndEnd[0];
        end = startAndEnd[1];
        Set<Object> queryTerms = new HashSet();
        IndexReader indexReader = indexSearcher.getIndexReader();
        ArrayList indexedFieldNames = new ArrayList(indexReader.getFieldNames(IndexReader.FieldOption.INDEXED));
        Query luceneQuery = (Query)QueryTranslatorUtil.translate((com.liferay.portal.kernel.search.Query)query);
        int scoredFieldNamesCount = LuceneHelperUtil.countScoredFieldNames(luceneQuery, ArrayUtil.toStringArray((Object[])indexedFieldNames.toArray()));
        HitsImpl hits = new HitsImpl();
        if (start < 0 || start > end) {
            return hits;
        }
        int subsetTotal = end - start;
        if (subsetTotal > PropsValues.INDEX_SEARCH_LIMIT) {
            subsetTotal = PropsValues.INDEX_SEARCH_LIMIT;
        }
        ArrayList<DocumentImpl> subsetDocs = new ArrayList<DocumentImpl>(subsetTotal);
        ArrayList<Float> subsetScores = new ArrayList<Float>(subsetTotal);
        SetBasedFieldSelector fieldSelector = null;
        QueryConfig queryConfig = query.getQueryConfig();
        Object[] selectedFieldNames = queryConfig.getSelectedFieldNames();
        if (ArrayUtil.isNotEmpty((Object[])selectedFieldNames) && !((String)selectedFieldNames[0]).equals("*")) {
            fieldSelector = new SetBasedFieldSelector(SetUtil.fromArray((Object[])selectedFieldNames), Collections.emptySet());
        }
        for (int i = start; i < start + subsetTotal; ++i) {
            String[] highlightFieldNames;
            int docId = browseHits[i].getDocid();
            org.apache.lucene.document.Document document = indexSearcher.doc(docId, (FieldSelector)fieldSelector);
            DocumentImpl subsetDocument = this.getDocument(document);
            for (String highlightFieldName : highlightFieldNames = queryConfig.getHighlightFieldNames()) {
                this.getSnippet(document, query, highlightFieldName, queryConfig.getLocale(), (Document)subsetDocument, queryTerms);
            }
            subsetDocs.add(subsetDocument);
            Float subsetScore = Float.valueOf(browseHits[i].getScore());
            if (scoredFieldNamesCount > 0) {
                subsetScore = Float.valueOf(subsetScore.floatValue() / (float)scoredFieldNamesCount);
            }
            subsetScores.add(subsetScore);
            if (!_log.isDebugEnabled()) continue;
            try {
                Explanation explanation = indexSearcher.explain(luceneQuery, docId);
                _log.debug((Object)explanation.toString());
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!queryConfig.isHighlightEnabled()) {
            queryTerms = this.getQueryTerms(query);
        }
        hits.setDocs(subsetDocs.toArray(new Document[subsetDocs.size()]));
        hits.setLength(total);
        hits.setQuery(query);
        hits.setQueryTerms(queryTerms.toArray(new String[queryTerms.size()]));
        hits.setScores(ArrayUtil.toFloatArray(subsetScores));
        hits.setSearchTime(searchTime);
        hits.setStart(startTime);
        return hits;
    }

    static {
        try {
            _runtimeFacetDataMapField = ReflectionUtil.getDeclaredField(BoboIndexReader.class, (String)"_runtimeFacetDataMap");
            _runtimeFacetHandlerMapField = ReflectionUtil.getDeclaredField(BoboIndexReader.class, (String)"_runtimeFacetHandlerMap");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class TermCollectingFormatter
    implements Formatter {
        private Set<String> _terms = new HashSet<String>();

        private TermCollectingFormatter() {
        }

        public Set<String> getTerms() {
            return this._terms;
        }

        public String highlightTerm(String originalText, TokenGroup tokenGroup) {
            if (tokenGroup.getTotalScore() > 0.0f) {
                this._terms.add(originalText);
            }
            return originalText;
        }
    }
}

