/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.LuceneFields;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.document.Field;

public class LuceneFileExtractor {
    public Field getFile(String field, byte[] bytes, String fileExt) {
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(bytes);
        return this.getFile(field, (InputStream)is, fileExt);
    }

    public Field getFile(String field, File file, String fileExt) throws IOException {
        FileInputStream is = new FileInputStream(file);
        return this.getFile(field, is, fileExt);
    }

    public Field getFile(String field, InputStream is, String fileExt) {
        String text = FileUtil.extractText((InputStream)is, (String)fileExt);
        if (Validator.isNotNull((String)PropsValues.LUCENE_FILE_EXTRACTOR_REGEXP_STRIP)) {
            text = this.regexpStrip(text);
        }
        return LuceneFields.getText(field, text);
    }

    protected String regexpStrip(String text) {
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            String s = String.valueOf(array[i]);
            if (s.matches(PropsValues.LUCENE_FILE_EXTRACTOR_REGEXP_STRIP)) continue;
            array[i] = 32;
        }
        return new String(array);
    }
}

