/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.search.lucene.FieldWeightSimilarity;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;

public class IndexSearcherManager {
    private volatile IndexSearcher _indexSearcher;
    private volatile boolean _invalid;

    public IndexSearcherManager(Directory directory) throws IOException {
        this._indexSearcher = this._createIndexSearcher(IndexReader.open((Directory)directory, (boolean)true));
    }

    public IndexSearcherManager(IndexWriter writer) throws IOException {
        this._indexSearcher = this._createIndexSearcher(IndexReader.open((IndexWriter)writer, (boolean)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSearcher acquire() throws IOException {
        if (this._invalid) {
            IndexSearcherManager indexSearcherManager = this;
            synchronized (indexSearcherManager) {
                if (this._invalid) {
                    IndexSearcher indexSearcher = this._indexSearcher;
                    if (indexSearcher == null) {
                        throw new AlreadyClosedException("Index searcher manager is closed");
                    }
                    IndexReader newIndexReader = IndexReader.openIfChanged((IndexReader)indexSearcher.getIndexReader());
                    if (newIndexReader != null) {
                        this._indexSearcher = this._createIndexSearcher(newIndexReader);
                        this.release(indexSearcher);
                    }
                    this._invalid = false;
                }
            }
        }
        IndexSearcher indexSearcher = null;
        while ((indexSearcher = this._indexSearcher) != null) {
            IndexReader indexReader = indexSearcher.getIndexReader();
            if (indexReader.tryIncRef()) {
                return indexSearcher;
            }
            if (indexSearcher != this._indexSearcher) continue;
            throw new IllegalStateException("Index reader was closed externally");
        }
        throw new AlreadyClosedException("Index searcher manager is closed");
    }

    public synchronized void close() throws IOException {
        IndexSearcher indexSearcher = this._indexSearcher;
        this._indexSearcher = null;
        this.release(indexSearcher);
    }

    public synchronized void invalidate() {
        this._invalid = true;
    }

    public void release(IndexSearcher indexSearcher) throws IOException {
        if (indexSearcher == null) {
            return;
        }
        IndexReader indexReader = indexSearcher.getIndexReader();
        indexReader.decRef();
    }

    private IndexSearcher _createIndexSearcher(IndexReader indexReader) {
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        indexSearcher.setDefaultFieldSortScoring(true, false);
        indexSearcher.setSimilarity((Similarity)new FieldWeightSimilarity());
        return indexSearcher;
    }
}

