/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.PortletLuceneComparator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.StopWatch;

public class SearchEngineInitializer
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(SearchEngineInitializer.class);
    private long _companyId;
    private boolean _finished;
    private Set<String> _usedSearchEngineIds;

    public SearchEngineInitializer(long companyId) {
        this._companyId = companyId;
        this._usedSearchEngineIds = new HashSet<String>();
    }

    public Set<String> getUsedSearchEngineIds() {
        return this._usedSearchEngineIds;
    }

    public void halt() {
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void reindex() {
        this.reindex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(int delay) {
        ShardUtil.pushCompanyService((long)this._companyId);
        try {
            this.doReIndex(delay);
        }
        finally {
            ShardUtil.popCompanyService();
        }
    }

    @Override
    public void run() {
        this.reindex(PropsValues.INDEX_ON_STARTUP_DELAY);
    }

    protected void doReIndex(int delay) {
        block12: {
            if (SearchEngineUtil.isIndexReadOnly()) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Reindexing Lucene started");
            }
            if (delay < 0) {
                delay = 0;
            }
            try {
                if (delay > 0) {
                    Thread.sleep(1000L * (long)delay);
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                SearchEngineUtil.removeCompany((long)this._companyId);
                SearchEngineUtil.initialize((long)this._companyId);
                List portlets = PortletLocalServiceUtil.getPortlets((long)this._companyId);
                portlets = ListUtil.sort((List)portlets, (Comparator)new PortletLuceneComparator());
                for (Portlet portlet : portlets) {
                    List indexers;
                    if (!portlet.isActive() || (indexers = portlet.getIndexerInstances()) == null) continue;
                    HashSet<String> searchEngineIds = new HashSet<String>();
                    for (Indexer indexer : indexers) {
                        String searchEngineId = indexer.getSearchEngineId();
                        if (searchEngineIds.add(searchEngineId)) {
                            SearchEngineUtil.deletePortletDocuments((String)searchEngineId, (long)this._companyId, (String)portlet.getPortletId(), (boolean)true);
                        }
                        this.reindex(indexer);
                    }
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Reindexing Lucene completed in " + stopWatch.getTime() / 1000L + " seconds"));
                }
            }
            catch (Exception e) {
                _log.error((Object)"Error encountered while reindexing", (Throwable)e);
                if (!_log.isInfoEnabled()) break block12;
                _log.info((Object)"Reindexing Lucene failed");
            }
        }
        this._finished = true;
    }

    protected void reindex(Indexer indexer) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reindexing with " + indexer.getClass() + " started"));
        }
        indexer.reindex(new String[]{String.valueOf(this._companyId)});
        this._usedSearchEngineIds.add(indexer.getSearchEngineId());
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reindexing with " + indexer.getClass() + " completed in " + stopWatch.getTime() / 1000L + " seconds"));
        }
    }
}

