/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilder;
import com.liferay.portal.kernel.search.SearchException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public class NGramHolderBuilderImpl
implements NGramHolderBuilder {
    public NGramHolder buildNGramHolder(String input) throws SearchException {
        return this.buildNGramHolder(input, this.getNGramMinLength(input.length()), this.getNGramMaxLength(input.length()));
    }

    public NGramHolder buildNGramHolder(String input, int nGramMaxLength) throws SearchException {
        if (nGramMaxLength <= 0) {
            nGramMaxLength = this.getNGramMaxLength(input.length());
        }
        return this.buildNGramHolder(input, this.getNGramMinLength(input.length()), nGramMaxLength);
    }

    public NGramHolder buildNGramHolder(String input, int nGramMinLength, int nGramMaxLength) throws SearchException {
        try {
            NGramHolder nGramHolder = new NGramHolder();
            NGramTokenizer nGramTokenizer = new NGramTokenizer((Reader)new StringReader(input), nGramMinLength, nGramMaxLength);
            CharTermAttribute charTermAttribute = (CharTermAttribute)nGramTokenizer.getAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)nGramTokenizer.getAttribute(OffsetAttribute.class);
            while (nGramTokenizer.incrementToken()) {
                String nGram = charTermAttribute.toString();
                int currentNGramSize = charTermAttribute.length();
                if (currentNGramSize < nGramMinLength || currentNGramSize > nGramMaxLength) continue;
                if (offsetAttribute.startOffset() == 0) {
                    nGramHolder.addNGramStart(currentNGramSize, nGram);
                    continue;
                }
                if (offsetAttribute.endOffset() == input.length()) {
                    nGramHolder.addNGramEnd(currentNGramSize, nGram);
                    continue;
                }
                nGramHolder.addNGram(currentNGramSize, nGram);
            }
            return nGramHolder;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    protected int getNGramMaxLength(int length) {
        if (length > 5) {
            return 4;
        }
        if (length == 5) {
            return 3;
        }
        return 2;
    }

    protected int getNGramMinLength(int length) {
        if (length > 5) {
            return 3;
        }
        if (length == 5) {
            return 2;
        }
        return 1;
    }
}

