/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.groovy;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class GroovyExecutor
extends BaseScriptingExecutor {
    private static final String _CACHE_NAME = GroovyExecutor.class.getName();
    private static final String _LANGUAGE = "groovy";
    private volatile GroovyShell _groovyShell = new GroovyShell();
    private final ConcurrentMap<ClassLoader, GroovyShell> _groovyShells = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private PortalCache<String, Script> _portalCache = SingleVMPoolUtil.getCache((String)_CACHE_NAME);

    public void clearCache() {
        this._portalCache.removeAll();
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Groovy");
        }
        Script compiledScript = this.getCompiledScript(script, classLoaders);
        Binding binding = new Binding(inputObjects);
        compiledScript.setBinding(binding);
        compiledScript.run();
        if (outputNames == null) {
            return null;
        }
        HashMap<String, Object> outputObjects = new HashMap<String, Object>();
        for (String outputName : outputNames) {
            outputObjects.put(outputName, binding.getVariable(outputName));
        }
        return outputObjects;
    }

    public String getLanguage() {
        return _LANGUAGE;
    }

    protected Script getCompiledScript(String script, ClassLoader[] classLoaders) {
        GroovyShell groovyShell = this.getGroovyShell(classLoaders);
        String key = String.valueOf(script.hashCode());
        Script compiledScript = (Script)this._portalCache.get((Serializable)((Object)key));
        if (compiledScript == null) {
            compiledScript = groovyShell.parse(script);
            this._portalCache.put((Serializable)((Object)key), (Object)compiledScript);
        }
        return compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroovyShell getGroovyShell(ClassLoader[] classLoaders) {
        GroovyShell oldGroovyShell;
        if (ArrayUtil.isEmpty((Object[])classLoaders)) {
            if (this._groovyShell == null) {
                GroovyExecutor groovyExecutor = this;
                synchronized (groovyExecutor) {
                    if (this._groovyShell == null) {
                        this._groovyShell = new GroovyShell();
                    }
                }
            }
            return this._groovyShell;
        }
        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
        GroovyShell groovyShell = (GroovyShell)this._groovyShells.get(aggregateClassLoader);
        if (groovyShell == null && (oldGroovyShell = this._groovyShells.putIfAbsent(aggregateClassLoader, groovyShell = new GroovyShell(aggregateClassLoader))) != null) {
            groovyShell = oldGroovyShell;
        }
        return groovyShell;
    }
}

