/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.beanshell;

import bsh.Interpreter;
import com.liferay.portal.kernel.scripting.BaseScriptingExecutor;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BeanShellExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "beanshell";

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script, ClassLoader ... classLoaders) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for BeanShell");
        }
        try {
            Interpreter interpreter = new Interpreter();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            if (ArrayUtil.isNotEmpty((Object[])classLoaders)) {
                ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (ClassLoader[])classLoaders);
                interpreter.setClassLoader(aggregateClassLoader);
            }
            interpreter.eval(script);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, interpreter.get(outputName));
            }
            return outputObjects;
        }
        catch (Exception e) {
            throw new ScriptingException(e.getMessage(), (Throwable)e);
        }
    }

    public String getLanguage() {
        return LANGUAGE;
    }
}

