/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting;

import com.liferay.portal.util.PropsValues;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassVisibilityChecker {
    public static final String ALL_CLASSES = "all_classes";
    private static final Set<String> _forbiddenClasses = new HashSet<String>(Arrays.asList(PropsValues.SCRIPTING_FORBIDDEN_CLASSES));
    private final boolean _allowAll;
    private final Set<Pattern> _allowedPatterns;
    private final boolean _denyAll;

    public ClassVisibilityChecker(Set<String> allowedClasses) {
        this._allowAll = allowedClasses != null && allowedClasses.contains(ALL_CLASSES);
        this._denyAll = _forbiddenClasses.contains(ALL_CLASSES);
        if (!this._allowAll && !this._denyAll) {
            this._allowedPatterns = new HashSet<Pattern>();
            for (String allowedClass : allowedClasses) {
                Pattern allowedPattern = Pattern.compile(allowedClass);
                this._allowedPatterns.add(allowedPattern);
            }
        } else {
            this._allowedPatterns = null;
        }
    }

    public boolean isVisible(String className) {
        if (this._denyAll || _forbiddenClasses.contains(className)) {
            return false;
        }
        if (this._allowAll) {
            return true;
        }
        for (Pattern allowedPattern : this._allowedPatterns) {
            Matcher matcher = allowedPattern.matcher(className);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

