/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler;

import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouterUtil;
import com.liferay.portal.kernel.cal.DayAndPosition;
import com.liferay.portal.kernel.cal.Duration;
import com.liferay.portal.kernel.cal.Recurrence;
import com.liferay.portal.kernel.cal.RecurrenceSerializer;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.JobState;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineClusterManager;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.SchedulerLifecycle;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;

@DoPrivileged
public class SchedulerEngineHelperImpl
implements SchedulerEngineHelper {
    private static Log _log = LogFactoryUtil.getLog(SchedulerEngineHelperImpl.class);
    private SchedulerEngine _schedulerEngine;
    private SchedulerEngineClusterManager _schedulerEngineClusterManager;

    public void addJob(Trigger trigger, StorageType storageType, String description, String destinationName, Message message, String messageListenerClassName, String portletId, int exceptionsMaxSize) throws SchedulerException {
        if (message == null) {
            message = new Message();
        }
        message.put("MESSAGE_LISTENER_CLASS_NAME", (Object)messageListenerClassName);
        message.put("PORTLET_ID", (Object)portletId);
        this.schedule(trigger, storageType, description, destinationName, message, exceptionsMaxSize);
    }

    public void addJob(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload, String messageListenerClassName, String portletId, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        this.addJob(trigger, storageType, description, destinationName, message, messageListenerClassName, portletId, exceptionsMaxSize);
    }

    public void addScriptingJob(Trigger trigger, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.put("LANGUAGE", (Object)language);
        message.put("SCRIPT", (Object)script);
        this.schedule(trigger, storageType, description, "liferay/scheduler_scripting", message, exceptionsMaxSize);
    }

    public void auditSchedulerJobs(Message message, TriggerState triggerState) throws SchedulerException {
        if (!PropsValues.AUDIT_MESSAGE_SCHEDULER_JOB) {
            return;
        }
        try {
            AuditMessage auditMessage = new AuditMessage("SCHEDULER", 0L, 0L, "", SchedulerEngine.class.getName(), "0", triggerState.toString(), new Date(), JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.serialize((Object)message)));
            auditMessage.setServerName(InetAddressUtil.getLocalHostName());
            auditMessage.setServerPort(PortalUtil.getPortalLocalPort((boolean)false));
            AuditRouterUtil.route((AuditMessage)auditMessage);
        }
        catch (Exception e) {
            throw new SchedulerException((Throwable)e);
        }
    }

    public void delete(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this.delete(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    public void delete(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(this.namespaceGroupName(groupName, storageType));
    }

    public void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.delete(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public String getCronText(Calendar calendar, boolean timeZoneSensitive) {
        return this.getCronText(null, calendar, timeZoneSensitive, 7);
    }

    public String getCronText(PortletRequest portletRequest, Calendar calendar, boolean timeZoneSensitive, int recurrenceType) {
        Calendar recurrenceCalendar = null;
        if (timeZoneSensitive) {
            recurrenceCalendar = CalendarFactoryUtil.getCalendar();
            recurrenceCalendar.setTime(calendar.getTime());
        } else {
            recurrenceCalendar = (Calendar)calendar.clone();
        }
        Recurrence recurrence = new Recurrence(recurrenceCalendar, new Duration(1, 0, 0, 0), recurrenceType);
        recurrence.setWeekStart(1);
        if (recurrenceType == 3) {
            int dailyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyType");
            if (dailyType == 0) {
                int dailyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"dailyInterval", (int)1);
                recurrence.setInterval(dailyInterval);
            } else {
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(2, 0), new DayAndPosition(3, 0), new DayAndPosition(4, 0), new DayAndPosition(5, 0), new DayAndPosition(6, 0)};
                recurrence.setByDay(dayPos);
            }
        } else if (recurrenceType == 4) {
            int weeklyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"weeklyInterval", (int)1);
            recurrence.setInterval(weeklyInterval);
            ArrayList<DayAndPosition> dayPos = new ArrayList<DayAndPosition>();
            this.addWeeklyDayPos(portletRequest, dayPos, 1);
            this.addWeeklyDayPos(portletRequest, dayPos, 2);
            this.addWeeklyDayPos(portletRequest, dayPos, 3);
            this.addWeeklyDayPos(portletRequest, dayPos, 4);
            this.addWeeklyDayPos(portletRequest, dayPos, 5);
            this.addWeeklyDayPos(portletRequest, dayPos, 6);
            this.addWeeklyDayPos(portletRequest, dayPos, 7);
            if (dayPos.isEmpty()) {
                dayPos.add(new DayAndPosition(2, 0));
            }
            recurrence.setByDay(dayPos.toArray(new DayAndPosition[0]));
        } else if (recurrenceType == 5) {
            int monthlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyType");
            if (monthlyType == 0) {
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay0", (int)1);
                recurrence.setByMonthDay(new int[]{monthlyDay});
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval0", (int)1);
                recurrence.setInterval(monthlyInterval);
            } else {
                int monthlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyPos");
                int monthlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyDay1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(monthlyDay, monthlyPos)};
                recurrence.setByDay(dayPos);
                int monthlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"monthlyInterval1", (int)1);
                recurrence.setInterval(monthlyInterval);
            }
        } else if (recurrenceType == 6) {
            int yearlyType = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyType");
            if (yearlyType == 0) {
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth0");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay0", (int)1);
                recurrence.setByMonth(new int[]{yearlyMonth});
                recurrence.setByMonthDay(new int[]{yearlyDay});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval0", (int)1);
                recurrence.setInterval(yearlyInterval);
            } else {
                int yearlyPos = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyPos");
                int yearlyDay = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyDay1");
                int yearlyMonth = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyMonth1");
                DayAndPosition[] dayPos = new DayAndPosition[]{new DayAndPosition(yearlyDay, yearlyPos)};
                recurrence.setByDay(dayPos);
                recurrence.setByMonth(new int[]{yearlyMonth});
                int yearlyInterval = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"yearlyInterval1", (int)1);
                recurrence.setInterval(yearlyInterval);
            }
        }
        return RecurrenceSerializer.toCronText((Recurrence)recurrence);
    }

    public Date getEndTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("END_TIME");
        }
        return jobState.getTriggerDate("END_TIME");
    }

    public Date getEndTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getEndTime(schedulerResponse);
        }
        return null;
    }

    public Date getFinalFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("FINAL_FIRE_TIME");
        }
        return jobState.getTriggerDate("FINAL_FIRE_TIME");
    }

    public Date getFinalFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getFinalFireTime(schedulerResponse);
        }
        return null;
    }

    public ObjectValuePair<Exception, Date>[] getJobExceptions(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getExceptions();
    }

    public ObjectValuePair<Exception, Date>[] getJobExceptions(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getJobExceptions(schedulerResponse);
        }
        return null;
    }

    public TriggerState getJobState(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        return jobState.getTriggerState();
    }

    public TriggerState getJobState(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getJobState(schedulerResponse);
        }
        return null;
    }

    public Date getNextFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("NEXT_FIRE_TIME");
        }
        return jobState.getTriggerDate("NEXT_FIRE_TIME");
    }

    public Date getNextFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getNextFireTime(schedulerResponse);
        }
        return null;
    }

    public Date getPreviousFireTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("PREVIOUS_FIRE_TIME");
        }
        return jobState.getTriggerDate("PREVIOUS_FIRE_TIME");
    }

    public Date getPreviousFireTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getPreviousFireTime(schedulerResponse);
        }
        return null;
    }

    public SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJob(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs();
    }

    public List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        ArrayList<SchedulerResponse> schedulerResponses = new ArrayList<SchedulerResponse>();
        for (SchedulerResponse schedulerResponse : this._schedulerEngine.getScheduledJobs()) {
            if (!storageType.equals((Object)schedulerResponse.getStorageType())) continue;
            schedulerResponses.add(schedulerResponse);
        }
        return schedulerResponses;
    }

    public List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        return this._schedulerEngine.getScheduledJobs(this.namespaceGroupName(groupName, storageType));
    }

    public Date getStartTime(SchedulerResponse schedulerResponse) {
        Message message = schedulerResponse.getMessage();
        JobState jobState = (JobState)message.get("JOB_STATE");
        TriggerState triggerState = jobState.getTriggerState();
        if (triggerState.equals((Object)TriggerState.NORMAL) || triggerState.equals((Object)TriggerState.PAUSED)) {
            return (Date)message.get("START_TIME");
        }
        return jobState.getTriggerDate("START_TIME");
    }

    public Date getStartTime(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse != null) {
            return this.getStartTime(schedulerResponse);
        }
        return null;
    }

    public void initialize() throws SchedulerException {
        if (this._schedulerEngineClusterManager != null) {
            this._schedulerEngineClusterManager.initialize();
        }
        SchedulerLifecycle schedulerLifecycle = new SchedulerLifecycle();
        schedulerLifecycle.registerPortalLifecycle(2);
    }

    public String namespaceGroupName(String groupName, StorageType storageType) {
        return storageType.toString().concat("#").concat(groupName);
    }

    public void pause(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(this.namespaceGroupName(groupName, storageType));
    }

    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.pause(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public void resume(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(this.namespaceGroupName(groupName, storageType));
    }

    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.resume(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public void schedule(SchedulerEntry schedulerEntry, StorageType storageType, String portletId, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.put("MESSAGE_LISTENER_CLASS_NAME", (Object)schedulerEntry.getEventListenerClass());
        message.put("PORTLET_ID", (Object)portletId);
        this.schedule(schedulerEntry.getTrigger(), storageType, schedulerEntry.getDescription(), "liferay/scheduler_dispatch", message, exceptionsMaxSize);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Message message, int exceptionsMaxSize) throws SchedulerException {
        if (message == null) {
            message = new Message();
        }
        message.put("EXCEPTIONS_MAX_SIZE", (Object)exceptionsMaxSize);
        trigger = TriggerFactoryUtil.buildTrigger((TriggerType)trigger.getTriggerType(), (String)trigger.getJobName(), (String)this.namespaceGroupName(trigger.getGroupName(), storageType), (Date)trigger.getStartDate(), (Date)trigger.getEndDate(), (Object)trigger.getTriggerContent());
        this._schedulerEngine.schedule(trigger, description, destinationName, message);
    }

    public void schedule(Trigger trigger, StorageType storageType, String description, String destinationName, Object payload, int exceptionsMaxSize) throws SchedulerException {
        Message message = new Message();
        message.setPayload(payload);
        this.schedule(trigger, storageType, description, destinationName, message, exceptionsMaxSize);
    }

    public void setSchedulerEngine(SchedulerEngine schedulerEngine) {
        this._schedulerEngine = schedulerEngine;
        if (schedulerEngine instanceof SchedulerEngineClusterManager) {
            this._schedulerEngineClusterManager = (SchedulerEngineClusterManager)schedulerEngine;
        }
    }

    public void shutdown() throws SchedulerException {
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        this._schedulerEngine.start();
    }

    public void suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.suppressError(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public void unschedule(SchedulerEntry schedulerEntry, StorageType storageType) throws SchedulerException {
        Trigger trigger = schedulerEntry.getTrigger();
        this.unschedule(trigger.getJobName(), trigger.getGroupName(), storageType);
    }

    public void unschedule(String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.unschedule(this.namespaceGroupName(groupName, storageType));
    }

    public void unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.unschedule(jobName, this.namespaceGroupName(groupName, storageType));
    }

    public void update(String jobName, String groupName, StorageType storageType, String description, String language, String script, int exceptionsMaxSize) throws SchedulerException {
        SchedulerResponse schedulerResponse = this.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse == null) {
            return;
        }
        Trigger trigger = schedulerResponse.getTrigger();
        if (trigger == null) {
            return;
        }
        Message message = schedulerResponse.getMessage();
        if (message == null) {
            return;
        }
        this.addScriptingJob(trigger, storageType, description, language, script, exceptionsMaxSize);
    }

    public void update(Trigger trigger, StorageType storageType) throws SchedulerException {
        trigger = TriggerFactoryUtil.buildTrigger((TriggerType)trigger.getTriggerType(), (String)trigger.getJobName(), (String)this.namespaceGroupName(trigger.getGroupName(), storageType), (Date)trigger.getStartDate(), (Date)trigger.getEndDate(), (Object)trigger.getTriggerContent());
        this._schedulerEngine.update(trigger);
    }

    public void updateMemorySchedulerClusterMaster() throws SchedulerException {
        if (this._schedulerEngineClusterManager == null) {
            _log.error((Object)"Unable to update memory scheduler cluster master because the portal is not using a clustered scheduler engine");
            return;
        }
        this._schedulerEngineClusterManager.updateMemorySchedulerClusterMaster();
    }

    protected void addWeeklyDayPos(PortletRequest portletRequest, List<DayAndPosition> list, int day) {
        if (ParamUtil.getBoolean((PortletRequest)portletRequest, (String)("weeklyDayPos" + day))) {
            list.add(new DayAndPosition(day, 0));
        }
    }
}

