/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sanitizer;

import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class SanitizerImpl
implements Sanitizer {
    private List<Sanitizer> _sanitizers = new CopyOnWriteArrayList<Sanitizer>();
    private ServiceTracker<?, Sanitizer> _serviceTracker;

    public SanitizerImpl() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Sanitizer.class, (ServiceTrackerCustomizer)new SanitizerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public byte[] sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, byte[] bytes, Map<String, Object> options) throws SanitizerException {
        for (Sanitizer sanitizer : this._sanitizers) {
            bytes = sanitizer.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, bytes, options);
        }
        return bytes;
    }

    public void sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, InputStream inputStream, OutputStream outputStream, Map<String, Object> options) throws SanitizerException {
        if (this._sanitizers.isEmpty()) {
            return;
        }
        if (this._sanitizers.size() == 1) {
            this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, inputStream, outputStream, options);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException ioe) {
            throw new SanitizerException((Throwable)ioe);
        }
        byte[] bytes = this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, byteArrayOutputStream.toByteArray(), options);
        try {
            outputStream.write(bytes);
        }
        catch (IOException ioe) {
            throw new SanitizerException((Throwable)ioe);
        }
    }

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String s, Map<String, Object> options) throws SanitizerException {
        for (Sanitizer sanitizer : this._sanitizers) {
            s = sanitizer.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, s, options);
        }
        return s;
    }

    public void unregisterSanitizer(Sanitizer sanitizer) {
        this._sanitizers.remove(sanitizer);
    }

    private class SanitizerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Sanitizer, Sanitizer> {
        private SanitizerServiceTrackerCustomizer() {
        }

        public Sanitizer addingService(ServiceReference<Sanitizer> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Sanitizer sanitizer = (Sanitizer)registry.getService(serviceReference);
            SanitizerImpl.this._sanitizers.add(sanitizer);
            return sanitizer;
        }

        public void modifiedService(ServiceReference<Sanitizer> serviceReference, Sanitizer sanitizer) {
        }

        public void removedService(ServiceReference<Sanitizer> serviceReference, Sanitizer sanitizer) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            SanitizerImpl.this._sanitizers.remove(sanitizer);
        }
    }
}

