/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.agent;

import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxException;
import com.liferay.portal.kernel.nio.intraband.mailbox.MailboxUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.Direction;
import com.liferay.portal.kernel.resiliency.spi.agent.annotation.DistributedRegistry;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThreadLocalDistributor;
import com.liferay.portal.kernel.util.ThreadLocalDistributorRegistry;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.util.ClassLoaderUtil;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SPIAgentSerializable
implements Serializable {
    protected transient String servletContextName;
    protected ThreadLocalDistributor[] threadLocalDistributors;
    private static Log _log = LogFactoryUtil.getLog(SPIAgentSerializable.class);

    public static Map<String, Serializable> extractDistributedRequestAttributes(HttpServletRequest request, Direction direction) {
        HashMap<String, Serializable> distributedRequestAttributes = new HashMap<String, Serializable>();
        Enumeration enumeration = request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (DistributedRegistry.isDistributed((String)name, (Direction)direction)) {
                Object value = request.getAttribute(name);
                if (value instanceof Serializable) {
                    distributedRequestAttributes.put(name, (Serializable)value);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Nonserializable distributed request attribute name " + name + " with value " + value));
                continue;
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Nondistributed request attribute name " + name + " with direction " + direction + " and value " + request.getAttribute(name)));
        }
        return distributedRequestAttributes;
    }

    public static Map<String, List<String>> extractRequestHeaders(HttpServletRequest request) {
        Map<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration nameEnumeration = request.getHeaderNames();
        while (nameEnumeration.hasMoreElements()) {
            Enumeration valueEnumeration;
            String headerName = (String)nameEnumeration.nextElement();
            if (StringUtil.equalsIgnoreCase((String)"Accept-Encoding", (String)headerName) || StringUtil.equalsIgnoreCase((String)"Cookie", (String)headerName) || (valueEnumeration = request.getHeaders(headerName)) == null) continue;
            List<Object> values = new ArrayList();
            while (valueEnumeration.hasMoreElements()) {
                values.add(valueEnumeration.nextElement());
            }
            if (values.isEmpty()) {
                values = Collections.emptyList();
            }
            headers.put(StringUtil.toLowerCase((String)headerName), values);
        }
        if (headers.isEmpty()) {
            headers = Collections.emptyMap();
        }
        return headers;
    }

    public static Map<String, Serializable> extractSessionAttributes(HttpServletRequest request) {
        Portlet portlet = (Portlet)request.getAttribute("SPI_AGENT_PORTLET");
        String portletSessionAttributesKey = "PORTLET_SESSION_ATTRIBUTES_".concat(portlet.getContextName());
        HashMap<String, Serializable> sessionAttributes = new HashMap<String, Serializable>();
        HttpSession session = request.getSession();
        Enumeration enumeration = session.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (name.startsWith("PORTLET_SESSION_ATTRIBUTES_") && !name.equals(portletSessionAttributesKey)) continue;
            Object value = session.getAttribute(name);
            if (value instanceof Serializable) {
                sessionAttributes.put(name, (Serializable)value);
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn((Object)("Nonserializable session attribute name " + name + " with value " + value));
        }
        HttpSession portletSession = (HttpSession)request.getAttribute("PORTLET_SESSION");
        if (portletSession != null) {
            request.removeAttribute("PORTLET_SESSION");
            HashMap<String, Serializable> portletSessionAttributes = new HashMap<String, Serializable>();
            enumeration = portletSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                Object value = portletSession.getAttribute(name);
                if (value instanceof Serializable) {
                    portletSessionAttributes.put(name, (Serializable)value);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Nonserializable session attribute name " + name + " with value " + value));
            }
            sessionAttributes.put(portletSessionAttributesKey, portletSessionAttributes);
        }
        return sessionAttributes;
    }

    public static <T extends SPIAgentSerializable> T readFrom(InputStream inputStream) throws IOException {
        int count;
        byte[] data = new byte[8];
        for (int length = 0; length < 8; length += count) {
            count = inputStream.read(data, length, 8 - length);
            if (count >= 0) continue;
            throw new EOFException();
        }
        long receipt = BigEndianCodec.getLong((byte[])data, (int)0);
        ByteBuffer byteBuffer = MailboxUtil.receiveMail((long)receipt);
        if (byteBuffer == null) {
            throw new IllegalArgumentException("No mail with receipt " + receipt);
        }
        Deserializer deserializer = new Deserializer(byteBuffer);
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            String servletContextName = deserializer.readString();
            ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)servletContextName);
            ClassLoaderUtil.setContextClassLoader(classLoader);
            SPIAgentSerializable t = (SPIAgentSerializable)deserializer.readObject();
            t.servletContextName = servletContextName;
            SPIAgentSerializable sPIAgentSerializable = t;
            return (T)sPIAgentSerializable;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }

    public SPIAgentSerializable(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public void writeTo(RegistrationReference registrationReference, OutputStream outputStream) throws IOException {
        Serializer serializer = new Serializer();
        serializer.writeString(this.servletContextName);
        serializer.writeObject((Serializable)this);
        try {
            byte[] data = new byte[8];
            ByteBuffer byteBuffer = serializer.toByteBuffer();
            long receipt = MailboxUtil.sendMail((RegistrationReference)registrationReference, (ByteBuffer)byteBuffer);
            BigEndianCodec.putLong((byte[])data, (int)0, (long)receipt);
            outputStream.write(data);
            outputStream.flush();
        }
        catch (MailboxException me) {
            throw new IOException(me);
        }
    }

    protected void captureThreadLocals() {
        for (ThreadLocalDistributor threadLocalDistributor : this.threadLocalDistributors = ThreadLocalDistributorRegistry.getThreadLocalDistributors()) {
            threadLocalDistributor.capture();
        }
    }

    protected void restoreThreadLocals() {
        for (ThreadLocalDistributor threadLocalDistributor : this.threadLocalDistributors) {
            threadLocalDistributor.restore();
        }
    }
}

