/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.repository.capabilities.CapabilityLocalRepository;
import com.liferay.portal.repository.capabilities.CapabilityRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RepositoryClassDefinition
implements RepositoryEventRegistry,
RepositoryEventTrigger,
RepositoryFactoryRegistry {
    private RepositoryDefiner _repositoryDefiner;
    private Map<Tuple, Collection<RepositoryEventListener<?, ?>>> _repositoryEventListeners = new HashMap();
    private RepositoryFactory _repositoryFactory;

    public RepositoryClassDefinition(RepositoryDefiner repositoryDefiner) {
        this._repositoryDefiner = repositoryDefiner;
    }

    public CapabilityLocalRepository createCapabilityLocalRepository(long repositoryId) throws PortalException {
        LocalRepository localRepository = this._repositoryFactory.createLocalRepository(repositoryId);
        CapabilityLocalRepository capabilityLocalRepository = new CapabilityLocalRepository(localRepository, this);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)capabilityLocalRepository);
        return capabilityLocalRepository;
    }

    public CapabilityRepository createCapabilityRepository(long repositoryId) throws PortalException {
        Repository repository = this._repositoryFactory.createRepository(repositoryId);
        CapabilityRepository capabilityRepository = new CapabilityRepository(repository, this);
        this._repositoryDefiner.registerCapabilities((CapabilityRegistry)capabilityRepository);
        return capabilityRepository;
    }

    public RepositoryEventTrigger getRepositoryEventTrigger() {
        return this;
    }

    public RepositoryFactory getRepositoryFactory() {
        return this._repositoryFactory;
    }

    public <S extends RepositoryEventType, T> void registerRepositoryEventListener(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListener) {
        Tuple key = new Tuple(new Object[]{repositoryEventTypeClass, modelClass});
        Collection<RepositoryEventListener<?, ?>> repositoryEventListeners = this._repositoryEventListeners.get(key);
        if (repositoryEventListeners == null) {
            repositoryEventListeners = new ArrayList();
            this._repositoryEventListeners.put(key, repositoryEventListeners);
        }
        repositoryEventListeners.add(repositoryEventListener);
    }

    public void setRepositoryFactory(RepositoryFactory repositoryFactory) {
        if (this._repositoryFactory != null) {
            throw new IllegalStateException("Repository factory already exists");
        }
        this._repositoryFactory = repositoryFactory;
    }

    public <S extends RepositoryEventType, T> void trigger(Class<S> repositoryEventTypeClass, Class<T> modelClass, T payload) throws PortalException {
        Tuple key = new Tuple(new Object[]{repositoryEventTypeClass, modelClass});
        Collection<RepositoryEventListener<?, ?>> repositoryEventListeners = this._repositoryEventListeners.get(key);
        if (repositoryEventListeners != null) {
            for (RepositoryEventListener<?, ?> repositoryEventListener : repositoryEventListeners) {
                repositoryEventListener.execute(payload);
            }
        }
    }
}

