/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.CapabilityProvider;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portal.service.RepositoryService;
import com.liferay.portal.service.ResourceLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionService;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalService;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class LiferayRepositoryBase
implements CapabilityProvider {
    protected DLAppHelperLocalService dlAppHelperLocalService;
    protected DLFileEntryLocalService dlFileEntryLocalService;
    protected DLFileEntryService dlFileEntryService;
    protected DLFileEntryTypeLocalService dlFileEntryTypeLocalService;
    protected DLFileVersionLocalService dlFileVersionLocalService;
    protected DLFileVersionService dlFileVersionService;
    protected DLFolderLocalService dlFolderLocalService;
    protected DLFolderService dlFolderService;
    protected RepositoryLocalService repositoryLocalService;
    protected RepositoryService repositoryService;
    protected ResourceLocalService resourceLocalService;
    private long _dlFolderId;
    private long _groupId;
    private long _repositoryId;

    public LiferayRepositoryBase(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long groupId, long repositoryId, long dlFolderId) {
        this.repositoryLocalService = repositoryLocalService;
        this.repositoryService = repositoryService;
        this.dlAppHelperLocalService = dlAppHelperLocalService;
        this.dlFileEntryLocalService = dlFileEntryLocalService;
        this.dlFileEntryService = dlFileEntryService;
        this.dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
        this.dlFileVersionLocalService = dlFileVersionLocalService;
        this.dlFileVersionService = dlFileVersionService;
        this.dlFolderLocalService = dlFolderLocalService;
        this.dlFolderService = dlFolderService;
        this.resourceLocalService = resourceLocalService;
        this._repositoryId = repositoryId;
        this._groupId = groupId;
        this._dlFolderId = dlFolderId;
    }

    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        throw new IllegalArgumentException(String.format("Capability %s is not supported by repository %s", capabilityClass.getName(), this.getRepositoryId()));
    }

    public long getRepositoryId() {
        return this._repositoryId;
    }

    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        return false;
    }

    protected void addFileEntryResources(DLFileEntry dlFileEntry, ServiceContext serviceContext) throws PortalException {
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.resourceLocalService.addResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), false, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            if (serviceContext.isDeriveDefaultPermissions()) {
                serviceContext.deriveDefaultPermissions(dlFileEntry.getRepositoryId(), DLFileEntryConstants.getClassName());
            }
            this.resourceLocalService.addModelResources(dlFileEntry.getCompanyId(), dlFileEntry.getGroupId(), dlFileEntry.getUserId(), DLFileEntry.class.getName(), dlFileEntry.getFileEntryId(), serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
    }

    protected long getDefaultFileEntryTypeId(ServiceContext serviceContext, long folderId) throws PortalException {
        folderId = this.dlFolderLocalService.getFolderId(serviceContext.getCompanyId(), folderId);
        return this.dlFileEntryTypeLocalService.getDefaultFileEntryTypeId(folderId);
    }

    protected HashMap<String, Fields> getFieldsMap(ServiceContext serviceContext, long fileEntryTypeId) throws PortalException {
        HashMap<String, Fields> fieldsMap = new HashMap<String, Fields>();
        if (fileEntryTypeId <= 0L) {
            return fieldsMap;
        }
        DLFileEntryType fileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
        List ddmStructures = fileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            String namespace = String.valueOf(ddmStructure.getStructureId());
            Fields fields = (Fields)serviceContext.getAttribute(Fields.class.getName() + ddmStructure.getStructureId());
            if (fields == null) {
                fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (String)namespace, (ServiceContext)serviceContext);
            }
            fieldsMap.put(ddmStructure.getStructureKey(), fields);
        }
        return fieldsMap;
    }

    protected long getGroupId() {
        return this._groupId;
    }

    protected SortedArrayList<Long> getLongList(ServiceContext serviceContext, String name) {
        String value = ParamUtil.getString((ServiceContext)serviceContext, (String)name);
        if (value == null) {
            return new SortedArrayList();
        }
        long[] longArray = StringUtil.split((String)value, (long)0L);
        SortedArrayList longList = new SortedArrayList();
        for (long longValue : longArray) {
            longList.add((Object)longValue);
        }
        return longList;
    }

    protected boolean isDefaultRepository() {
        return this._groupId == this._repositoryId;
    }

    protected long toFolderId(long folderId) {
        if (folderId == 0L) {
            return this._dlFolderId;
        }
        return folderId;
    }

    protected List<Long> toFolderIds(List<Long> folderIds) {
        ArrayList<Long> toFolderIds = new ArrayList<Long>(folderIds.size());
        for (long folderId : folderIds) {
            toFolderIds.add(this.toFolderId(folderId));
        }
        return toFolderIds;
    }
}

