/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SortedArrayList;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.repository.liferayrepository.LiferayRepositoryBase;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileVersion;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portal.service.RepositoryService;
import com.liferay.portal.service.ResourceLocalService;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionService;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalService;
import com.liferay.portlet.documentlibrary.service.DLFolderService;
import com.liferay.portlet.documentlibrary.util.RepositoryModelUtil;
import com.liferay.portlet.documentlibrary.util.comparator.DLFileEntryOrderByComparator;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class LiferayLocalRepository
extends LiferayRepositoryBase
implements LocalRepository {
    public LiferayLocalRepository(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService, DLAppHelperLocalService dlAppHelperLocalService, DLFileEntryLocalService dlFileEntryLocalService, DLFileEntryService dlFileEntryService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, DLFileVersionLocalService dlFileVersionLocalService, DLFileVersionService dlFileVersionService, DLFolderLocalService dlFolderLocalService, DLFolderService dlFolderService, ResourceLocalService resourceLocalService, long groupId, long repositoryId, long dlFolderId) {
        super(repositoryLocalService, repositoryService, dlAppHelperLocalService, dlFileEntryLocalService, dlFileEntryService, dlFileEntryTypeLocalService, dlFileVersionLocalService, dlFileVersionService, dlFolderLocalService, dlFolderService, resourceLocalService, groupId, repositoryId, dlFolderId);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)this.getDefaultFileEntryTypeId(serviceContext, folderId));
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.addFileEntry(userId, this.getGroupId(), this.getRepositoryId(), this.toFolderId(folderId), sourceFileName, mimeType, title, description, changeLog, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        this.addFileEntryResources(dlFileEntry, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        boolean mountPoint = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"mountPoint");
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(userId, this.getGroupId(), this.getRepositoryId(), mountPoint, this.toFolderId(parentFolderId), name, description, false, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public void addRepository(long groupId, String name, String description, String portletKey, UnicodeProperties typeSettingsProperties) {
    }

    public void deleteAll() throws PortalException {
        this.dlFolderLocalService.deleteAll(this.getGroupId());
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this.dlFileEntryLocalService.deleteFileEntry(fileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.fetchFolder(folderId);
        if (dlFolder != null) {
            this.dlFolderLocalService.deleteFolder(folderId);
        }
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(fileEntryId);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntry(this.getGroupId(), this.toFolderId(folderId), title);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.getFileEntryByUuidAndGroupId(uuid, this.getGroupId());
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion = this.dlFileVersionLocalService.getFileVersion(fileVersionId);
        return new LiferayFileVersion(dlFileVersion);
    }

    public Folder getFolder(long folderId) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(folderId);
        return new LiferayFolder(dlFolder);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.getFolder(this.getGroupId(), this.toFolderId(parentFolderId), name);
        return new LiferayFolder(dlFolder);
    }

    public List<FileEntry> getRepositoryFileEntries(long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) {
        List dlFileEntries = this.dlFileEntryLocalService.getGroupFileEntries(this.getGroupId(), 0L, rootFolderId, start, end, DLFileEntryOrderByComparator.getOrderByComparator(obc));
        return RepositoryModelUtil.toFileEntries(dlFileEntries);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.moveFileEntry(userId, fileEntryId, this.toFolderId(newFolderId), serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        DLFolder dlFolder = this.dlFolderLocalService.moveFolder(userId, folderId, parentFolderId, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.dlAppHelperLocalService.updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        long size = 0L;
        if (file != null) {
            size = file.length();
        }
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, file, null, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId", (long)-1L);
        HashMap<String, Fields> fieldsMap = this.getFieldsMap(serviceContext, fileEntryTypeId);
        DLFileEntry dlFileEntry = this.dlFileEntryLocalService.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, fileEntryTypeId, fieldsMap, null, is, size, serviceContext);
        return new LiferayFileEntry(dlFileEntry);
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        long defaultFileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"defaultFileEntryTypeId");
        SortedArrayList<Long> fileEntryTypeIds = this.getLongList(serviceContext, "dlFileEntryTypesSearchContainerPrimaryKeys");
        boolean overrideFileEntryTypes = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"overrideFileEntryTypes");
        DLFolder dlFolder = this.dlFolderLocalService.updateFolder(this.toFolderId(folderId), this.toFolderId(parentFolderId), name, description, defaultFileEntryTypeId, fileEntryTypeIds, overrideFileEntryTypes, serviceContext);
        return new LiferayFolder(dlFolder);
    }

    public UnicodeProperties updateRepository(UnicodeProperties typeSettingsProperties) {
        return typeSettingsProperties;
    }
}

