/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.external;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.cmis.BaseCmisRepository;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.repository.cmis.CMISRepository;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.proxy.BaseRepositoryProxyBean;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;
import com.liferay.portal.service.ClassNameLocalService;
import com.liferay.portal.service.CompanyLocalService;
import com.liferay.portal.service.RepositoryEntryLocalService;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portlet.asset.service.AssetEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalService;

public class LegacyExternalRepositoryFactory
implements RepositoryFactory {
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=CompanyLocalService.class)
    private CompanyLocalService _companyLocalService;
    @BeanReference(type=DLAppHelperLocalService.class)
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @BeanReference(type=RepositoryEntryLocalService.class)
    private RepositoryEntryLocalService _repositoryEntryLocalService;
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;
    @BeanReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        BaseRepository baseRepository = this.createBaseRepository(repositoryId);
        return baseRepository.getLocalRepository();
    }

    public Repository createRepository(long repositoryId) throws PortalException {
        return this.createBaseRepository(repositoryId);
    }

    protected BaseRepository createBaseRepository(long repositoryId) throws PortalException {
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        return this.createExternalRepositoryImpl(repositoryId, classNameId);
    }

    protected BaseRepository createExternalRepositoryImpl(long repositoryId, long classNameId) throws PortalException {
        BaseRepositoryProxyBean baseRepositoryProxyBean;
        ClassLoaderBeanHandler classLoaderBeanHandler;
        Object bean;
        BaseRepository baseRepository = null;
        com.liferay.portal.model.Repository repository = null;
        try {
            repository = this._repositoryLocalService.getRepository(repositoryId);
            ClassName className = this._classNameLocalService.getClassName(classNameId);
            String repositoryImplClassName = className.getValue();
            baseRepository = ExternalRepositoryFactoryUtil.getInstance(repositoryImplClassName);
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to find a valid repository for class name ID " + classNameId, (Throwable)e);
        }
        CMISRepositoryHandler cmisRepositoryHandler = null;
        if (baseRepository instanceof CMISRepositoryHandler) {
            cmisRepositoryHandler = (CMISRepositoryHandler)baseRepository;
        } else if (baseRepository instanceof BaseRepositoryProxyBean && (bean = (classLoaderBeanHandler = (ClassLoaderBeanHandler)ProxyUtil.getInvocationHandler((Object)(baseRepositoryProxyBean = (BaseRepositoryProxyBean)baseRepository).getProxyBean())).getBean()) instanceof CMISRepositoryHandler) {
            cmisRepositoryHandler = (CMISRepositoryHandler)bean;
        }
        if (cmisRepositoryHandler != null) {
            CMISRepository cmisRepository = new CMISRepository(cmisRepositoryHandler);
            cmisRepositoryHandler.setCmisRepository((BaseCmisRepository)cmisRepository);
            this.setupRepository(repositoryId, repository, (BaseRepository)cmisRepository);
        }
        this.setupRepository(repositoryId, repository, baseRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            baseRepository.initRepository();
        }
        return baseRepository;
    }

    protected long getRepositoryClassNameId(long repositoryId) {
        com.liferay.portal.model.Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            return repository.getClassNameId();
        }
        return this._classNameLocalService.getClassNameId(LiferayRepository.class.getName());
    }

    protected void setupRepository(long repositoryId, com.liferay.portal.model.Repository repository, BaseRepository baseRepository) {
        baseRepository.setAssetEntryLocalService(this._assetEntryLocalService);
        baseRepository.setCompanyId(repository.getCompanyId());
        baseRepository.setCompanyLocalService(this._companyLocalService);
        baseRepository.setDLAppHelperLocalService(this._dlAppHelperLocalService);
        baseRepository.setGroupId(repository.getGroupId());
        baseRepository.setRepositoryEntryLocalService(this._repositoryEntryLocalService);
        baseRepository.setRepositoryId(repositoryId);
        baseRepository.setTypeSettingsProperties(repository.getTypeSettingsProperties());
        baseRepository.setUserLocalService(this._userLocalService);
    }
}

