/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.repository.cmis.Session;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.cmis.CMISRepositoryUtil;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.util.PropsValues;
import java.util.HashMap;
import java.util.Locale;
import org.apache.chemistry.opencmis.commons.enums.BindingType;

public class CMISAtomPubRepository
extends CMISRepositoryHandler {
    private static final String _ATOMPUB_URL = "ATOMPUB_URL";
    private static final String _CONFIGURATION_ATOMPUB = "ATOMPUB";
    private static final String _REPOSITORY_ID = "REPOSITORY_ID";
    private static final String[] _SUPPORTED_CONFIGURATIONS = new String[]{"ATOMPUB"};
    private static final String[][] _SUPPORTED_PARAMETERS = new String[][]{{"ATOMPUB_URL", "REPOSITORY_ID"}};

    public Session getSession() throws PortalException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.getTypeSettingsValue(_ATOMPUB_URL));
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameters.put("org.apache.chemistry.opencmis.binding.compression", Boolean.TRUE.toString());
        Locale locale = LocaleUtil.getSiteDefault();
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", locale.getCountry());
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", locale.getLanguage());
        String login = this.getLogin();
        String password = null;
        if (Validator.isNotNull((String)login)) {
            password = PrincipalThreadLocal.getPassword();
        } else {
            login = PropsValues.DL_REPOSITORY_GUEST_USERNAME;
            password = PropsValues.DL_REPOSITORY_GUEST_PASSWORD;
        }
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.user", login);
        CMISRepositoryUtil.checkRepository(this.getRepositoryId(), parameters, this.getTypeSettingsProperties(), _REPOSITORY_ID);
        return CMISRepositoryUtil.createSession(parameters);
    }

    public String[] getSupportedConfigurations() {
        return _SUPPORTED_CONFIGURATIONS;
    }

    public String[][] getSupportedParameters() {
        return _SUPPORTED_PARAMETERS;
    }

    protected String getTypeSettingsValue(String typeSettingsKey) throws InvalidRepositoryException {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return CMISRepositoryUtil.getTypeSettingsValue(typeSettingsProperties, typeSettingsKey);
    }
}

