/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.BaseRepositoryModelOperation;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class TemporaryFileEntriesCapabilityImpl
implements TemporaryFileEntriesCapability {
    private static final String _FOLDER_NAME_TEMP = "temp";
    private static final String _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT = "temporaryFilesTimeout";
    private static final long _TEMPORARY_FILE_ENTRIES_TIMEOUT_DEFAULT = 43200000L;
    private LocalRepository _localRepository;

    public TemporaryFileEntriesCapabilityImpl(LocalRepository localRepository) {
        this._localRepository = localRepository;
    }

    public FileEntry addTemporaryFileEntry(UUID callerUuid, long userId, String folderPath, String fileName, String mimeType, InputStream inputStream) throws PortalException {
        Folder folder = this.addTempFolder(userId, callerUuid, folderPath);
        File file = null;
        try {
            file = FileUtil.createTempFile((InputStream)inputStream);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            FileEntry fileEntry = this._localRepository.addFileEntry(userId, folder.getFolderId(), fileName, mimeType, fileName, "", "", file, serviceContext);
            return fileEntry;
        }
        catch (IOException ioe) {
            throw new SystemException("Unable to write temporary file", (Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void deleteExpiredTemporaryFileEntries() throws PortalException {
        BulkOperationCapability bulkOperationCapability = (BulkOperationCapability)this._localRepository.getCapability(BulkOperationCapability.class);
        BulkOperationCapability.Filter bulkFilter = new BulkOperationCapability.Filter(BulkOperationCapability.Field.CreateDate.class, BulkOperationCapability.Operator.LT, (Object)new Date(System.currentTimeMillis() - this.getTemporaryFileEntriesTimeout()));
        bulkOperationCapability.execute(bulkFilter, (RepositoryModelOperation)new DeleteExpiredTemporaryFilesRepositoryModelOperation());
    }

    public void deleteTemporaryFileEntry(UUID callerUuid, String folderPath, String fileName) throws PortalException {
        try {
            FileEntry fileEntry = this.getTemporaryFileEntries(callerUuid, folderPath, fileName);
            this._localRepository.deleteFileEntry(fileEntry.getFileEntryId());
        }
        catch (NoSuchModelException nsme) {
            // empty catch block
        }
    }

    public List<FileEntry> getTemporaryFileEntries(UUID callerUuid, String folderPath) throws PortalException {
        try {
            Folder folder = this.getTempFolder(callerUuid, folderPath);
            return this._localRepository.getRepositoryFileEntries(folder.getFolderId(), -1, -1, null);
        }
        catch (NoSuchModelException nsme) {
            return Collections.emptyList();
        }
    }

    public FileEntry getTemporaryFileEntries(UUID callerUuid, String folderPath, String fileName) throws PortalException {
        Folder folder = this.getTempFolder(callerUuid, folderPath);
        return this._localRepository.getFileEntry(folder.getFolderId(), fileName);
    }

    public long getTemporaryFileEntriesTimeout() {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._localRepository.getCapability(ConfigurationCapability.class);
        String temporaryFileEntriesTimeout = configurationCapability.getProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT);
        if (temporaryFileEntriesTimeout == null) {
            return 43200000L;
        }
        return GetterUtil.getLong((String)temporaryFileEntriesTimeout);
    }

    public void setTemporaryFileEntriesTimeout(long temporaryFileEntriesTimeout) {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._localRepository.getCapability(ConfigurationCapability.class);
        configurationCapability.setProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT, String.valueOf(temporaryFileEntriesTimeout));
    }

    protected Folder addFolder(long userId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        try {
            return this.getFolder(parentFolderId, folderName);
        }
        catch (NoSuchFolderException nsfe) {
            return this._localRepository.addFolder(userId, parentFolderId, folderName, "", serviceContext);
        }
    }

    protected Folder addFolders(long userId, long folderId, String folderPath, ServiceContext serviceContext) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this.addFolder(userId, folderId, folderName, serviceContext);
            folderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder addTempFolder(long userId, UUID callerUuid, String folderPath) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Folder tempFolder = this.addFolder(userId, 0L, _FOLDER_NAME_TEMP, serviceContext);
        Folder folder = this.addFolder(userId, tempFolder.getFolderId(), callerUuid.toString(), serviceContext);
        return this.addFolders(userId, folder.getFolderId(), folderPath, serviceContext);
    }

    protected Folder getDeepestFolder(long parentFolderId, String folderPath) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this._localRepository.getFolder(parentFolderId, folderName);
            parentFolderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder getFolder(long parentFolderId, String folderName) throws PortalException {
        return this._localRepository.getFolder(parentFolderId, folderName);
    }

    protected Folder getTempFolder(UUID callerUuid, String folderPath) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Folder tempFolder = this.getFolder(0L, _FOLDER_NAME_TEMP);
        Folder folder = this.getFolder(tempFolder.getFolderId(), callerUuid.toString());
        return this.getDeepestFolder(folder.getFolderId(), folderPath);
    }

    private class DeleteExpiredTemporaryFilesRepositoryModelOperation
    extends BaseRepositoryModelOperation {
        private DeleteExpiredTemporaryFilesRepositoryModelOperation() {
        }

        public void execute(FileEntry fileEntry) throws PortalException {
            TemporaryFileEntriesCapabilityImpl.this._localRepository.deleteFileEntry(fileEntry.getFileEntryId());
        }
    }
}

