/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.model.Repository;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryConstants;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderConstants;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.service.TrashEntryLocalServiceUtil;
import com.liferay.portlet.trash.service.TrashVersionLocalServiceUtil;
import java.util.List;

public class LiferayTrashCapability
implements TrashCapability {
    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        this.deleteTrashEntry(fileEntry);
        DLAppLocalServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException {
        List dlFileEntries = DLFileEntryLocalServiceUtil.getGroupFileEntries((long)folder.getGroupId(), (long)0L, (long)folder.getFolderId(), (int)-1, (int)-1, null);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            DLAppHelperLocalServiceUtil.deleteFileEntry((FileEntry)fileEntry);
            this.deleteTrashEntry(fileEntry);
        }
        DLAppHelperLocalServiceUtil.deleteFolder((Folder)folder);
        this.deleteTrashEntry(folder);
        DLFolderLocalServiceUtil.deleteFolder((long)folder.getFolderId(), (boolean)false);
    }

    public boolean isInTrash(Folder folder) {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        return dlFolder.isInTrash();
    }

    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, Folder destinationFolder, ServiceContext serviceContext) throws PortalException {
        return DLAppHelperLocalServiceUtil.moveFileEntryFromTrash((long)userId, (FileEntry)fileEntry, (long)destinationFolder.getFolderId(), (ServiceContext)serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        return DLAppHelperLocalServiceUtil.moveFileEntryToTrash((long)userId, (FileEntry)fileEntry);
    }

    public Folder moveFolderFromTrash(long userId, Folder folder, Folder destinationFolder, ServiceContext serviceContext) throws PortalException {
        return DLAppHelperLocalServiceUtil.moveFolderFromTrash((long)userId, (Folder)folder, (long)destinationFolder.getFolderId(), (ServiceContext)serviceContext);
    }

    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        return DLAppHelperLocalServiceUtil.moveFolderToTrash((long)userId, (Folder)folder);
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, (RepositoryEventListener)new DeleteFileEntryRepositoryEventListener());
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, Folder.class, (RepositoryEventListener)new DeleteFolderRepositoryEventListener());
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, LocalRepository.class, (RepositoryEventListener)new DeleteLocalRepositoryEventListener());
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
        DLAppHelperLocalServiceUtil.restoreFileEntryFromTrash((long)userId, (FileEntry)fileEntry);
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
        DLAppHelperLocalServiceUtil.restoreFolderFromTrash((long)userId, (Folder)folder);
    }

    protected void deleteRepositoryTrashEntries(long repositoryId, String className) {
        List trashEntries = TrashEntryLocalServiceUtil.getEntries((long)repositoryId, (String)className);
        for (TrashEntry trashEntry : trashEntries) {
            TrashEntryLocalServiceUtil.deleteTrashEntry((TrashEntry)trashEntry);
        }
    }

    protected void deleteTrashEntries(long repositoryId) throws PortalException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepository((long)repositoryId);
        if (repository == null) {
            this.deleteRepositoryTrashEntries(repositoryId, DLFileEntry.class.getName());
            this.deleteRepositoryTrashEntries(repositoryId, DLFolder.class.getName());
        } else {
            this.deleteTrashEntries(repository.getGroupId(), repository.getDlFolderId());
        }
    }

    protected void deleteTrashEntries(long groupId, long dlFolderId) throws PortalException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setStatus(-1);
        List foldersAndFileEntriesAndFileShortcuts = DLFolderLocalServiceUtil.getFoldersAndFileEntriesAndFileShortcuts((long)groupId, (long)dlFolderId, null, (boolean)true, (QueryDefinition)queryDefinition);
        for (Object folderFileEntryOrFileShortcut : foldersAndFileEntriesAndFileShortcuts) {
            if (folderFileEntryOrFileShortcut instanceof DLFileEntry) {
                this.deleteTrashEntry((DLFileEntry)folderFileEntryOrFileShortcut);
                continue;
            }
            if (!(folderFileEntryOrFileShortcut instanceof DLFolder)) continue;
            DLFolder dlFolder = (DLFolder)folderFileEntryOrFileShortcut;
            this.deleteTrashEntries(dlFolder.getGroupId(), dlFolder.getFolderId());
            this.deleteTrashEntry(dlFolder);
        }
    }

    protected void deleteTrashEntry(DLFileEntry dlFileEntry) throws PortalException {
        if (!dlFileEntry.isInTrash()) {
            return;
        }
        if (dlFileEntry.isInTrashExplicitly()) {
            TrashEntryLocalServiceUtil.deleteEntry((String)DLFileEntryConstants.getClassName(), (long)dlFileEntry.getFileEntryId());
        } else {
            List dlFileVersions = dlFileEntry.getFileVersions(-1);
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                TrashVersionLocalServiceUtil.deleteTrashVersion((String)DLFileVersion.class.getName(), (long)dlFileVersion.getFileVersionId());
            }
        }
    }

    protected void deleteTrashEntry(DLFolder dlFolder) throws PortalException {
        if (!dlFolder.isInTrash()) {
            return;
        }
        if (dlFolder.isInTrashExplicitly()) {
            TrashEntryLocalServiceUtil.deleteEntry((String)DLFolderConstants.getClassName(), (long)dlFolder.getFolderId());
        } else {
            TrashVersionLocalServiceUtil.deleteTrashVersion((String)DLFolderConstants.getClassName(), (long)dlFolder.getFolderId());
        }
    }

    protected void deleteTrashEntry(FileEntry fileEntry) throws PortalException {
        this.deleteTrashEntry((DLFileEntry)fileEntry.getModel());
    }

    protected void deleteTrashEntry(Folder folder) throws PortalException {
        this.deleteTrashEntry((DLFolder)folder.getModel());
    }

    private class DeleteLocalRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, LocalRepository> {
        private DeleteLocalRepositoryEventListener() {
        }

        public void execute(LocalRepository localRepository) throws PortalException {
            LiferayTrashCapability.this.deleteTrashEntries(localRepository.getRepositoryId());
        }
    }

    private class DeleteFolderRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, Folder> {
        private DeleteFolderRepositoryEventListener() {
        }

        public void execute(Folder folder) throws PortalException {
            LiferayTrashCapability.this.deleteTrashEntry(folder);
        }
    }

    private class DeleteFileEntryRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, FileEntry> {
        private DeleteFileEntryRepositoryEventListener() {
        }

        public void execute(FileEntry fileEntry) throws PortalException {
            LiferayTrashCapability.this.deleteTrashEntry(fileEntry);
        }
    }
}

