/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Group;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLSyncEvent;
import com.liferay.portlet.documentlibrary.service.DLSyncEventLocalServiceUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.concurrent.Callable;

public class LiferaySyncCapability
implements SyncCapability {
    public void addFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("add", fileEntry);
    }

    public void addFolder(Folder folder) {
        this.registerDLSyncEventCallback("add", folder);
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("delete", fileEntry);
    }

    public void deleteFolder(Folder folder) {
        this.registerDLSyncEventCallback("delete", folder);
    }

    public void destroyLocalRepository(LocalRepository localRepository) throws PortalException {
        if (!localRepository.isCapabilityProvided(BulkOperationCapability.class)) {
            return;
        }
        BulkOperationCapability bulkOperationCapability = (BulkOperationCapability)localRepository.getCapability(BulkOperationCapability.class);
        bulkOperationCapability.execute((RepositoryModelOperation)new DeleteRepositoryModelOperation());
    }

    public void moveFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("move", fileEntry);
    }

    public void moveFolder(Folder folder) {
        this.registerDLSyncEventCallback("move", folder);
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Add.class, Folder.class, "addFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Update.class, FileEntry.class, "updateFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Update.class, Folder.class, "updateFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Delete.class, FileEntry.class, "deleteFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Delete.class, Folder.class, "deleteFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Move.class, FileEntry.class, "moveFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, RepositoryEventType.Move.class, Folder.class, "moveFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, "trashFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, TrashRepositoryEventType.EntryRestored.class, FileEntry.class, "restoreFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, TrashRepositoryEventType.EntryRestored.class, Folder.class, "restoreFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, TrashRepositoryEventType.EntryTrashed.class, Folder.class, "trashFolder");
        this.registerRepositoryEventListener(repositoryEventRegistry, WorkflowRepositoryEventType.Add.class, FileEntry.class, "addFileEntry");
        this.registerRepositoryEventListener(repositoryEventRegistry, WorkflowRepositoryEventType.Update.class, FileEntry.class, "updateFileEntry");
    }

    public void restoreFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("restore", fileEntry);
    }

    public void restoreFolder(Folder folder) {
        this.registerDLSyncEventCallback("restore", folder);
    }

    public void trashFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("trash", fileEntry);
    }

    public void trashFolder(Folder folder) {
        this.registerDLSyncEventCallback("trash", folder);
    }

    public void updateFileEntry(FileEntry fileEntry) throws PortalException {
        this.registerDLSyncEventCallback("update", fileEntry);
    }

    public void updateFolder(Folder folder) {
        this.registerDLSyncEventCallback("update", folder);
    }

    protected boolean isStagingGroup(long groupId) {
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return group.isStagingGroup();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void registerDLSyncEventCallback(String event, FileEntry fileEntry) throws PortalException {
        FileVersion fileVersion;
        if (this.isStagingGroup(fileEntry.getGroupId()) || !(fileEntry instanceof LiferayFileEntry)) {
            return;
        }
        if (!(event.equals("delete") || event.equals("trash") || (fileVersion = fileEntry.getFileVersion()).isApproved())) {
            return;
        }
        this.registerDLSyncEventCallback(event, "file", fileEntry.getFileEntryId());
    }

    protected void registerDLSyncEventCallback(String event, Folder folder) {
        if (this.isStagingGroup(folder.getGroupId()) || !(folder instanceof LiferayFolder)) {
            return;
        }
        this.registerDLSyncEventCallback(event, "folder", folder.getFolderId());
    }

    protected void registerDLSyncEventCallback(final String event, final String type, final long typePK) {
        DLSyncEvent dlSyncEvent = DLSyncEventLocalServiceUtil.addDLSyncEvent((String)event, (String)type, (long)typePK);
        final long modifiedTime = dlSyncEvent.getModifiedTime();
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                HashMap<String, Object> values = new HashMap<String, Object>(4);
                values.put("event", event);
                values.put("modifiedTime", modifiedTime);
                values.put("type", type);
                values.put("typePK", typePK);
                message.setValues(values);
                MessageBusUtil.sendMessage((String)"liferay/document_library_sync_event_processor", (Message)message);
                return null;
            }
        });
    }

    protected <S extends RepositoryEventType, T> void registerRepositoryEventListener(RepositoryEventRegistry repositoryEventRegistry, Class<S> repositoryEventTypeClass, Class<T> modelClass, String methodName) {
        MethodKeyRepositoryEventListener repositoryEventListener = new MethodKeyRepositoryEventListener(new MethodKey(LiferaySyncCapability.class, methodName, new Class[]{modelClass}));
        repositoryEventRegistry.registerRepositoryEventListener(repositoryEventTypeClass, modelClass, repositoryEventListener);
    }

    private class MethodKeyRepositoryEventListener<S extends RepositoryEventType, T>
    implements RepositoryEventListener<S, T> {
        private MethodKey _methodKey;

        public MethodKeyRepositoryEventListener(MethodKey methodKey) {
            this._methodKey = methodKey;
        }

        public void execute(T target) {
            try {
                Method method = this._methodKey.getMethod();
                method.invoke((Object)LiferaySyncCapability.this, target);
            }
            catch (IllegalAccessException iae) {
                throw new SystemException((Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                throw new SystemException((Throwable)ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new SystemException((Throwable)nsme);
            }
        }
    }

    private class DeleteRepositoryModelOperation
    implements RepositoryModelOperation {
        private DeleteRepositoryModelOperation() {
        }

        public void execute(FileEntry fileEntry) throws PortalException {
            LiferaySyncCapability.this.deleteFileEntry(fileEntry);
        }

        public void execute(FileVersion fileVersion) {
        }

        public void execute(Folder folder) {
            LiferaySyncCapability.this.deleteFolder(folder);
        }
    }
}

