/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.HashMap;
import java.util.Map;

public class LiferayBulkOperationCapability
implements BulkOperationCapability {
    private static final Map<Class<? extends BulkOperationCapability.Field<?>>, String> _fieldNames = new HashMap();
    private long _repositoryId;

    public LiferayBulkOperationCapability(long repositoryId) {
        this._repositoryId = repositoryId;
    }

    public void execute(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        this.executeOnAllFileEntries(filter, repositoryModelOperation);
        this.executeOnAllFolders(filter, repositoryModelOperation);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        this.execute(null, repositoryModelOperation);
    }

    protected void executeOnAllFileEntries(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = DLFileEntryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod((ActionableDynamicQuery.AddCriteriaMethod)new RepositoryModelAddCriteriaMethod(filter));
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new FileEntryPerformActionMethod(repositoryModelOperation));
        actionableDynamicQuery.performActions();
    }

    protected void executeOnAllFolders(BulkOperationCapability.Filter<?> filter, RepositoryModelOperation repositoryModelOperation) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = DLFolderLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod((ActionableDynamicQuery.AddCriteriaMethod)new RepositoryModelAddCriteriaMethod(filter));
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new FolderPerformActionMethod(repositoryModelOperation));
        actionableDynamicQuery.performActions();
    }

    static {
        _fieldNames.put(BulkOperationCapability.Field.CreateDate.class, "createDate");
    }

    private class RepositoryModelAddCriteriaMethod
    implements ActionableDynamicQuery.AddCriteriaMethod {
        private BulkOperationCapability.Filter<?> _filter;

        public RepositoryModelAddCriteriaMethod(BulkOperationCapability.Filter<?> filter) {
            this._filter = filter;
        }

        public void addCriteria(DynamicQuery dynamicQuery) {
            dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"repositoryId", (Object)LiferayBulkOperationCapability.this._repositoryId));
            if (this._filter != null) {
                this.addFilterCriteria(dynamicQuery);
            }
        }

        protected void addFilterCriteria(DynamicQuery dynamicQuery) {
            Class field = this._filter.getField();
            String fieldName = (String)_fieldNames.get(field);
            if (fieldName == null) {
                throw new UnsupportedOperationException("Unsupported field " + field.getName());
            }
            BulkOperationCapability.Operator operator = this._filter.getOperator();
            Object value = this._filter.getValue();
            if (operator == BulkOperationCapability.Operator.EQ) {
                dynamicQuery.add(RestrictionsFactoryUtil.eq((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.LE) {
                dynamicQuery.add(RestrictionsFactoryUtil.le((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.LT) {
                dynamicQuery.add(RestrictionsFactoryUtil.lt((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.GE) {
                dynamicQuery.add(RestrictionsFactoryUtil.ge((String)fieldName, (Object)value));
            } else if (operator == BulkOperationCapability.Operator.GT) {
                dynamicQuery.add(RestrictionsFactoryUtil.gt((String)fieldName, (Object)value));
            }
        }
    }

    private static class FolderPerformActionMethod
    implements ActionableDynamicQuery.PerformActionMethod {
        private final RepositoryModelOperation _repositoryModelOperation;

        public FolderPerformActionMethod(RepositoryModelOperation repositoryModelOperation) {
            this._repositoryModelOperation = repositoryModelOperation;
        }

        public void performAction(Object object) throws PortalException {
            DLFolder dlFolder = (DLFolder)object;
            if (dlFolder.isMountPoint()) {
                return;
            }
            LiferayFolder folder = new LiferayFolder(dlFolder);
            folder.execute(this._repositoryModelOperation);
        }
    }

    private static class FileEntryPerformActionMethod
    implements ActionableDynamicQuery.PerformActionMethod {
        private RepositoryModelOperation _repositoryModelOperation;

        public FileEntryPerformActionMethod(RepositoryModelOperation repositoryModelOperation) {
            this._repositoryModelOperation = repositoryModelOperation;
        }

        public void performAction(Object object) throws PortalException {
            DLFileEntry dlFileEntry = (DLFileEntry)object;
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            fileEntry.execute(this._repositoryModelOperation);
        }
    }
}

