/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Repository;
import com.liferay.portal.service.RepositoryLocalServiceUtil;

public class ConfigurationCapabilityImpl
implements ConfigurationCapability {
    private DocumentRepository _repository;

    public ConfigurationCapabilityImpl(DocumentRepository repository) {
        this._repository = repository;
    }

    public String getProperty(Class<? extends Capability> owner, String key) {
        try {
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)this._repository.getRepositoryId());
            UnicodeProperties typeSettingsProperties = repository.getTypeSettingsProperties();
            return typeSettingsProperties.getProperty(this._getUniqueKey(owner, key));
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to read repository configuration property", (Throwable)pe);
        }
    }

    public void setProperty(Class<? extends Capability> owner, String key, String value) {
        try {
            Repository repository = RepositoryLocalServiceUtil.getRepository((long)this._repository.getRepositoryId());
            UnicodeProperties typeSettingsProperties = repository.getTypeSettingsProperties();
            typeSettingsProperties.setProperty(this._getUniqueKey(owner, key), value);
            repository.setTypeSettingsProperties(typeSettingsProperties);
            RepositoryLocalServiceUtil.updateRepository((Repository)repository);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to set repository configuration property", (Throwable)pe);
        }
    }

    private String _getUniqueKey(Class<? extends Capability> owner, String key) {
        Class<?> clazz = owner.getClass();
        return clazz.getName() + "#" + key;
    }
}

