/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.repository.capabilities.BaseCapabilityRepository;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class CapabilityRepository
extends BaseCapabilityRepository<Repository>
implements Repository {
    private RepositoryEventTrigger _repositoryEventTrigger;

    public CapabilityRepository(Repository repository, RepositoryEventTrigger repositoryEventTrigger) {
        super(repository);
        this._repositoryEventTrigger = repositoryEventTrigger;
    }

    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.addFileEntry(folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry addFileEntry(long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.addFileEntry(folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder addFolder(long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.addFolder(parentFolderId, name, description, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, Folder.class, (Object)folder);
        return folder;
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileVersion fileVersion = repository.cancelCheckOut(fileEntryId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileVersion.getFileEntry());
        return fileVersion;
    }

    public void checkInFileEntry(long fileEntryId, boolean major, String changeLog, ServiceContext serviceContext) throws PortalException {
        ((Repository)this.getRepository()).checkInFileEntry(fileEntryId, major, changeLog, serviceContext);
    }

    @Deprecated
    public void checkInFileEntry(long fileEntryId, String lockUuid) throws PortalException {
        ((Repository)this.getRepository()).checkInFileEntry(fileEntryId, lockUuid);
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        ((Repository)this.getRepository()).checkInFileEntry(fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return ((Repository)this.getRepository()).checkOutFileEntry(fileEntryId, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        return ((Repository)this.getRepository()).checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
    }

    public FileEntry copyFileEntry(long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.copyFileEntry(groupId, fileEntryId, destFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)fileEntry);
        repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntry(long folderId, String title) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.getFileEntry(folderId, title);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)fileEntry);
        repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.getFolder(folderId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)folder);
        repository.deleteFolder(folderId);
    }

    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.getFolder(parentFolderId, name);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)folder);
        repository.deleteFolder(parentFolderId, name);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, fileEntryTypeId, start, end, obc);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntries(folderId, mimeTypes, start, end, obc);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntriesCount(folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return ((Repository)this.getRepository()).getFileEntryByUuid(uuid);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return ((Repository)this.getRepository()).getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return ((Repository)this.getRepository()).getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFolders(parentFolderId, includeMountFolders, start, end, obc);
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFolders(parentFolderId, status, includeMountFolders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, obc);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimetypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimetypes, includeMountFolders, start, end, obc);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimetypes, boolean includeMountFolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimetypes, includeMountFolders);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersCount(parentFolderId, status, includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        return ((Repository)this.getRepository()).getFoldersFileEntriesCount(folderIds, status);
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        return ((Repository)this.getRepository()).getMountFolders(parentFolderId, start, end, obc);
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return ((Repository)this.getRepository()).getMountFoldersCount(parentFolderId);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntries(userId, rootFolderId, start, end, obc);
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, obc);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        return ((Repository)this.getRepository()).getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    @Override
    public long getRepositoryId() {
        return ((Repository)this.getRepository()).getRepositoryId();
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        ((Repository)this.getRepository()).getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return ((Repository)this.getRepository()).getSubfolderIds(folderId, recurse);
    }

    @Deprecated
    public Lock lockFileEntry(long fileEntryId) throws PortalException {
        return ((Repository)this.getRepository()).lockFileEntry(fileEntryId);
    }

    @Deprecated
    public Lock lockFileEntry(long fileEntryId, String owner, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).lockFileEntry(fileEntryId, owner, expirationTime);
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return ((Repository)this.getRepository()).lockFolder(folderId);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.moveFileEntry(fileEntryId, newFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder moveFolder(long folderId, long newParentFolderId, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.moveFolder(folderId, newParentFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, Folder.class, (Object)folder);
        return folder;
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return ((Repository)this.getRepository()).refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        ((Repository)this.getRepository()).revertFileEntry(fileEntryId, version, serviceContext);
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).search(creatorUserId, status, start, end);
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return ((Repository)this.getRepository()).search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        return ((Repository)this.getRepository()).search(searchContext);
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return ((Repository)this.getRepository()).search(searchContext, query);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        ((Repository)this.getRepository()).unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        ((Repository)this.getRepository()).unlockFolder(parentFolderId, name, lockUuid);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        FileEntry fileEntry = repository.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        Repository repository = (Repository)this.getRepository();
        Folder folder = repository.updateFolder(folderId, name, description, serviceContext);
        if (folderId != 0L) {
            this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, Folder.class, (Object)folder);
        }
        return folder;
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return ((Repository)this.getRepository()).verifyInheritableLock(folderId, lockUuid);
    }
}

