/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventTrigger;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.repository.capabilities.BaseCapabilityRepository;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class CapabilityLocalRepository
extends BaseCapabilityRepository<LocalRepository>
implements LocalRepository {
    private RepositoryEventTrigger _repositoryEventTrigger;

    public CapabilityLocalRepository(LocalRepository localRepository, RepositoryEventTrigger repositoryEventTrigger) {
        super(localRepository);
        this._repositoryEventTrigger = repositoryEventTrigger;
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        Folder folder = localRepository.addFolder(userId, parentFolderId, name, description, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Add.class, Folder.class, (Object)folder);
        return folder;
    }

    public void deleteAll() throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, LocalRepository.class, (Object)localRepository);
        SyncCapability syncCapability = (SyncCapability)this.getInternalCapability(SyncCapability.class);
        if (syncCapability != null) {
            syncCapability.destroyLocalRepository((LocalRepository)this);
        }
        localRepository.deleteAll();
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.getFileEntry(fileEntryId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, FileEntry.class, (Object)fileEntry);
        localRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        Folder folder = localRepository.getFolder(folderId);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Delete.class, Folder.class, (Object)folder);
        localRepository.deleteFolder(folderId);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFileEntryByUuid(uuid);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return ((LocalRepository)this.getRepository()).getFolder(parentFolderId, name);
    }

    public List<FileEntry> getRepositoryFileEntries(long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        return ((LocalRepository)this.getRepository()).getRepositoryFileEntries(rootFolderId, start, end, obc);
    }

    @Override
    public long getRepositoryId() {
        return ((LocalRepository)this.getRepository()).getRepositoryId();
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        Folder folder = localRepository.moveFolder(userId, folderId, parentFolderId, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Move.class, Folder.class, (Object)folder);
        return folder;
    }

    public void updateAsset(long userId, FileEntry fileEntry, FileVersion fileVersion, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        ((LocalRepository)this.getRepository()).updateAsset(userId, fileEntry, fileVersion, assetCategoryIds, assetTagNames, assetLinkEntryIds);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        FileEntry fileEntry = localRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, FileEntry.class, (Object)fileEntry);
        return fileEntry;
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LocalRepository localRepository = (LocalRepository)this.getRepository();
        Folder folder = localRepository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
        this._repositoryEventTrigger.trigger(RepositoryEventType.Update.class, Folder.class, (Object)folder);
        return folder;
    }
}

