/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.UndeployedExternalRepositoryException;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.RepositoryEventTriggerCapability;
import com.liferay.portal.kernel.repository.cmis.CMISRepositoryHandler;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.repository.capabilities.BaseCapabilityRepository;
import com.liferay.portal.repository.capabilities.CapabilityLocalRepository;
import com.liferay.portal.repository.capabilities.CapabilityRepository;
import com.liferay.portal.repository.capabilities.ConfigurationCapabilityImpl;
import com.liferay.portal.repository.capabilities.LiferayRepositoryEventTriggerCapability;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.repository.proxy.BaseRepositoryProxyBean;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import com.liferay.portal.service.ClassNameLocalService;
import com.liferay.portal.service.RepositoryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileEntryService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalService;
import com.liferay.portlet.documentlibrary.service.DLFileVersionService;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalService;
import com.liferay.portlet.documentlibrary.service.DLFolderService;

public class RepositoryFactoryImpl
implements RepositoryFactory {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=DLFileEntryLocalService.class)
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @BeanReference(type=DLFileEntryService.class)
    private DLFileEntryService _dlFileEntryService;
    @BeanReference(type=DLFileVersionLocalService.class)
    private DLFileVersionLocalService _dlFileVersionLocalService;
    @BeanReference(type=DLFileVersionService.class)
    private DLFileVersionService _dlFileVersionService;
    @BeanReference(type=DLFolderLocalService.class)
    private DLFolderLocalService _dlFolderLocalService;
    @BeanReference(type=DLFolderService.class)
    private DLFolderService _dlFolderService;
    @BeanReference(type=RepositoryClassDefinitionCatalog.class)
    private RepositoryClassDefinitionCatalog _repositoryClassDefinitionCatalog;
    @BeanReference(type=RepositoryLocalService.class)
    private RepositoryLocalService _repositoryLocalService;

    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        RepositoryClassDefinition repositoryClassDefinition = this.getRepositoryClassDefinition(classNameId);
        CapabilityLocalRepository capabilityLocalRepository = repositoryClassDefinition.createCapabilityLocalRepository(repositoryId);
        this.setupCommonCapabilities(capabilityLocalRepository, repositoryClassDefinition);
        return capabilityLocalRepository;
    }

    public Repository createRepository(long repositoryId) throws PortalException {
        long classNameId = this.getRepositoryClassNameId(repositoryId);
        RepositoryClassDefinition repositoryClassDefinition = this.getRepositoryClassDefinition(classNameId);
        CapabilityRepository capabilityRepository = repositoryClassDefinition.createCapabilityRepository(repositoryId);
        this.setupCommonCapabilities(capabilityRepository, repositoryClassDefinition);
        this.setupCapabilityRepositoryCapabilities(capabilityRepository);
        return capabilityRepository;
    }

    protected CMISRepositoryHandler getCMISRepositoryHandler(Repository repository) {
        BaseRepositoryProxyBean baseRepositoryProxyBean;
        ClassLoaderBeanHandler classLoaderBeanHandler;
        Object bean;
        if (repository instanceof BaseRepositoryProxyBean && (bean = (classLoaderBeanHandler = (ClassLoaderBeanHandler)ProxyUtil.getInvocationHandler((Object)(baseRepositoryProxyBean = (BaseRepositoryProxyBean)repository).getProxyBean())).getBean()) instanceof CMISRepositoryHandler) {
            return (CMISRepositoryHandler)bean;
        }
        return null;
    }

    protected DLFileEntryLocalService getDlFileEntryLocalService() {
        return this._dlFileEntryLocalService;
    }

    protected DLFileEntryService getDlFileEntryService() {
        return this._dlFileEntryService;
    }

    protected DLFileVersionLocalService getDlFileVersionLocalService() {
        return this._dlFileVersionLocalService;
    }

    protected DLFileVersionService getDlFileVersionService() {
        return this._dlFileVersionService;
    }

    protected DLFolderLocalService getDlFolderLocalService() {
        return this._dlFolderLocalService;
    }

    protected DLFolderService getDlFolderService() {
        return this._dlFolderService;
    }

    protected com.liferay.portal.model.Repository getRepository(long repositoryId) {
        RepositoryLocalService repositoryLocalService = this.getRepositoryLocalService();
        return repositoryLocalService.fetchRepository(repositoryId);
    }

    protected RepositoryClassDefinition getRepositoryClassDefinition(long classNameId) throws PortalException {
        ClassName className = this._classNameLocalService.getClassName(classNameId);
        RepositoryClassDefinition repositoryDefinition = this._repositoryClassDefinitionCatalog.getRepositoryClassDefinition(className.getClassName());
        if (repositoryDefinition == null) {
            throw new UndeployedExternalRepositoryException(className);
        }
        return repositoryDefinition;
    }

    protected long getRepositoryClassNameId(long repositoryId) {
        com.liferay.portal.model.Repository repository = this._repositoryLocalService.fetchRepository(repositoryId);
        if (repository != null) {
            return repository.getClassNameId();
        }
        return this._classNameLocalService.getClassNameId(LiferayRepository.class.getName());
    }

    protected RepositoryLocalService getRepositoryLocalService() {
        return this._repositoryLocalService;
    }

    protected void setupCapabilityRepositoryCapabilities(CapabilityRepository capabilityRepository) {
        Repository repository = (Repository)capabilityRepository.getRepository();
        CMISRepositoryHandler cmisRepositoryHandler = this.getCMISRepositoryHandler(repository);
        if (cmisRepositoryHandler != null) {
            capabilityRepository.addExportedCapability(CMISRepositoryHandler.class, cmisRepositoryHandler);
        }
    }

    protected void setupCommonCapabilities(BaseCapabilityRepository<?> baseCapabilityRepository, RepositoryClassDefinition repositoryClassDefinition) {
        if (!baseCapabilityRepository.isCapabilityProvided(ConfigurationCapability.class)) {
            baseCapabilityRepository.addExportedCapability(ConfigurationCapability.class, new ConfigurationCapabilityImpl(baseCapabilityRepository));
        }
        if (!baseCapabilityRepository.isCapabilityProvided(RepositoryEventTriggerCapability.class)) {
            baseCapabilityRepository.addExportedCapability(RepositoryEventTriggerCapability.class, new LiferayRepositoryEventTriggerCapability(repositoryClassDefinition.getRepositoryEventTrigger()));
        }
    }
}

