/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.pop.MessageListenerWrapper;
import com.liferay.portal.pop.messaging.POPNotificationsMessageListener;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class POPServerUtil {
    private static Log _log = LogFactoryUtil.getLog(POPServerUtil.class);
    private static POPServerUtil _instance = new POPServerUtil();
    private List<MessageListener> _listeners = new ArrayList<MessageListener>();
    private ServiceRegistrationMap<MessageListener> _serviceRegistrations = new ServiceRegistrationMap();
    private ServiceTracker<MessageListener, MessageListenerWrapper> _serviceTracker;

    public static void addListener(MessageListener listener) throws Exception {
        _instance._addListener(listener);
    }

    public static void deleteListener(MessageListener listener) throws Exception {
        _instance._deleteListener(listener);
    }

    public static List<MessageListener> getListeners() throws Exception {
        return _instance._getListeners();
    }

    public static void start() {
        _instance._start();
    }

    private POPServerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(MessageListener.class, (ServiceTrackerCustomizer)new MessageListenerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _addListener(MessageListener listener) {
        if (listener == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not add null listener");
            }
            return;
        }
        Registry registry = RegistryUtil.getRegistry();
        ServiceRegistration serviceRegistration = registry.registerService(MessageListener.class, (Object)listener);
        this._serviceRegistrations.put((Object)listener, (Object)serviceRegistration);
    }

    private void _deleteListener(MessageListener listener) {
        if (listener == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not delete null listener");
            }
            return;
        }
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)listener);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private List<MessageListener> _getListeners() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listeners size " + this._listeners.size()));
        }
        return Collections.unmodifiableList(this._listeners);
    }

    private void _start() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Start");
        }
        try {
            SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl();
            schedulerEntry.setEventListenerClass(POPNotificationsMessageListener.class.getName());
            schedulerEntry.setTimeUnit(TimeUnit.MINUTE);
            schedulerEntry.setTriggerType(TriggerType.SIMPLE);
            schedulerEntry.setTriggerValue(PropsValues.POP_SERVER_NOTIFICATIONS_INTERVAL);
            SchedulerEngineHelperUtil.schedule((SchedulerEntry)schedulerEntry, (StorageType)StorageType.MEMORY_CLUSTERED, null, (int)0);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private class MessageListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MessageListener, MessageListenerWrapper> {
        private MessageListenerServiceTrackerCustomizer() {
        }

        public MessageListenerWrapper addingService(ServiceReference<MessageListener> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            MessageListener messageListener = (MessageListener)registry.getService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add listener " + messageListener.getClass().getName()));
            }
            MessageListenerWrapper messageListenerWrapper = new MessageListenerWrapper(messageListener);
            POPServerUtil.this._deleteListener(messageListenerWrapper);
            POPServerUtil.this._listeners.add(messageListenerWrapper);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Listeners size " + POPServerUtil.this._listeners.size()));
            }
            return messageListenerWrapper;
        }

        public void modifiedService(ServiceReference<MessageListener> serviceReference, MessageListenerWrapper messageListenerWrapper) {
        }

        public void removedService(ServiceReference<MessageListener> serviceReference, MessageListenerWrapper messageListenerWrapper) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            MessageListener messageListener = messageListenerWrapper.getMessageListener();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Delete listener " + ClassUtil.getClassName((Object)messageListener)));
            }
            POPServerUtil.this._listeners.remove(messageListenerWrapper);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Listeners size " + POPServerUtil.this._listeners.size()));
            }
        }
    }
}

