/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.pop;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import javax.mail.Message;

@ProviderType
public class MessageListenerWrapper
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(MessageListenerWrapper.class);
    private MessageListener _listener;

    public MessageListenerWrapper(MessageListener listener) {
        this._listener = listener;
    }

    public boolean accept(String from, String recipient, Message message) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listener " + this._listener.getClass().getName()));
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipient " + recipient));
        }
        boolean value = this._listener.accept(from, recipient, message);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Accept " + value));
        }
        return value;
    }

    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Listener " + this._listener.getClass().getName()));
            _log.debug((Object)("From " + from));
            _log.debug((Object)("Recipient " + recipient));
            _log.debug((Object)("Message " + message));
        }
        this._listener.deliver(from, recipient, message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessageListenerWrapper)) {
            return false;
        }
        MessageListenerWrapper listener = (MessageListenerWrapper)obj;
        String id = listener.getId();
        return this.getId().equals(id);
    }

    public String getId() {
        return this._listener.getId();
    }

    public MessageListener getMessageListener() {
        return this._listener;
    }

    public int hashCode() {
        return this._listener.getId().hashCode();
    }
}

