/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.dao.shard.ShardPollerProcessorWrapper;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.proxy.TargetLocator;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyInstallationUtil;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyUtil;
import com.liferay.portal.nio.intraband.proxy.StubHolder;
import com.liferay.portal.nio.intraband.proxy.StubMap;
import com.liferay.portal.nio.intraband.proxy.WarnLogExceptionHandler;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.StringServiceRegistrationMap;
import java.util.HashMap;
import java.util.concurrent.Future;

public class PollerProcessorUtil {
    private static PollerProcessorUtil _instance = new PollerProcessorUtil();
    private StubMap<PollerProcessor> _pollerPorcessors = new StubMap<PollerProcessor>(new StubHolder.StubCreator<PollerProcessor>(){

        @Override
        public PollerProcessor createStub(String portletId, PollerProcessor pollerProcessor, RegistrationReference registrationReference) throws Exception {
            Future<String[]> skeletonProxyMethodSignaturesFuture = IntrabandProxyInstallationUtil.installSkeleton(registrationReference, PollerProcessor.class, (TargetLocator)new PollerProcessorTargetLocator());
            String[] skeletonProxyMethodSignatures = skeletonProxyMethodSignaturesFuture.get();
            Class<?> stubPollerClass = IntrabandProxyUtil.getStubClass(PollerProcessor.class, PollerProcessor.class.getName());
            IntrabandProxyInstallationUtil.checkProxyMethodSignatures(skeletonProxyMethodSignatures, IntrabandProxyUtil.getProxyMethodSignatures(stubPollerClass));
            return (PollerProcessor)IntrabandProxyUtil.newStubInstance(stubPollerClass, portletId, registrationReference, WarnLogExceptionHandler.INSTANCE);
        }

        @Override
        public PollerProcessor onCreationFailure(String portletId, PollerProcessor pollerProcessor, Exception e) {
            return pollerProcessor;
        }

        @Override
        public PollerProcessor onInvalidation(String portletId, PollerProcessor pollerProcessor, PollerProcessor stubPollerProcessor) {
            PollerProcessorUtil.this._pollerPorcessors.removeStubHolder(portletId, stubPollerProcessor);
            return pollerProcessor;
        }
    });
    private StringServiceRegistrationMap<PollerProcessor> _serviceRegistrations = new StringServiceRegistrationMap();
    private ServiceTracker<PollerProcessor, PollerProcessor> _serviceTracker;

    public static void addPollerProcessor(String portletId, PollerProcessor pollerProcessor) {
        _instance._addPollerProcessor(portletId, pollerProcessor);
    }

    public static void deletePollerProcessor(String portletId) {
        _instance._deletePollerProcessor(portletId);
    }

    public static PollerProcessor getPollerProcessor(String portletId) {
        return _instance._getPollerProcessor(portletId);
    }

    private PollerProcessorUtil() {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=*)(objectClass=" + PollerProcessor.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new PollerProcessorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private void _addPollerProcessor(String portletId, PollerProcessor pollerProcessor) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.portlet.name", portletId);
        ServiceRegistration serviceRegistration = registry.registerService(PollerProcessor.class, (Object)pollerProcessor, properties);
        this._serviceRegistrations.put((Object)portletId, (Object)serviceRegistration);
    }

    private void _deletePollerProcessor(String portletId) {
        ServiceRegistration serviceRegistration = (ServiceRegistration)this._serviceRegistrations.remove((Object)portletId);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private PollerProcessor _getPollerProcessor(String portletId) {
        return this._pollerPorcessors.get(portletId);
    }

    private class PollerProcessorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PollerProcessor, PollerProcessor> {
        private PollerProcessorServiceTrackerCustomizer() {
        }

        public PollerProcessor addingService(ServiceReference<PollerProcessor> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PollerProcessor pollerProcessor = (PollerProcessor)registry.getService(serviceReference);
            if (ShardUtil.isEnabled()) {
                pollerProcessor = new ShardPollerProcessorWrapper(pollerProcessor);
            }
            String portletId = (String)serviceReference.getProperty("javax.portlet.name");
            PollerProcessorUtil.this._pollerPorcessors.put(portletId, pollerProcessor);
            return pollerProcessor;
        }

        public void modifiedService(ServiceReference<PollerProcessor> serviceReference, PollerProcessor pollerProcessor) {
        }

        public void removedService(ServiceReference<PollerProcessor> serviceReference, PollerProcessor pollerProcessor) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            String portletId = (String)serviceReference.getProperty("javax.portlet.name");
            PollerProcessorUtil.this._pollerPorcessors.remove(portletId);
        }
    }

    private static class PollerProcessorTargetLocator
    implements TargetLocator {
        private PollerProcessorTargetLocator() {
        }

        public Object getTarget(String portletId) {
            PollerProcessor pollerProcessor = PollerProcessorUtil.getPollerProcessor(portletId);
            if (pollerProcessor == null) {
                throw new IllegalStateException("Unable to get poller processor for portlet " + portletId);
            }
            return pollerProcessor;
        }
    }
}

