/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.parsers.creole.ast;

import com.liferay.portal.parsers.creole.ast.ASTNode;
import com.liferay.portal.util.PropsValues;

public abstract class URLNode
extends ASTNode {
    private String _link;
    private String[] _supportedProtocols = PropsValues.WIKI_PARSERS_CREOLE_SUPPORTED_PROTOCOLS;

    public URLNode() {
    }

    public URLNode(int token) {
        super(token);
    }

    public URLNode(int token, String link) {
        this(token);
        this._link = link;
    }

    public URLNode(String link) {
        this._link = link;
    }

    public String getLink() {
        return this._link;
    }

    public String[] getSupportedProtocols() {
        return this._supportedProtocols;
    }

    public boolean isAbsoluteLink() {
        for (String supportedProtocol : this.getSupportedProtocols()) {
            if (!this._link.startsWith(supportedProtocol)) continue;
            return true;
        }
        return false;
    }

    public void setLink(String link) {
        this._link = link;
    }

    public void setSupportedProtocols(String[] supportedProtocols) {
        this._supportedProtocols = supportedProtocols;
    }
}

