/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics.service;

import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.kernel.monitoring.statistics.DataSample;
import com.liferay.portal.kernel.monitoring.statistics.DataSampleThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.monitoring.jmx.MethodSignature;
import com.liferay.portal.monitoring.statistics.service.ServiceRequestDataSample;
import com.liferay.portal.spring.aop.ChainableMethodAdvice;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceMonitorAdvice
extends ChainableMethodAdvice {
    private static boolean _active;
    private static Set<String> _monitoredClasses;
    private static Set<MethodSignature> _monitoredMethods;
    private static boolean _permissiveMode;
    private static ThreadLocal<ServiceRequestDataSample> _serviceRequestDataSampleThreadLocal;

    @Deprecated
    public static ServiceMonitorAdvice getInstance() {
        return new ServiceMonitorAdvice();
    }

    public static boolean isActive() {
        return _active;
    }

    public void addMonitoredClass(String className) {
        _monitoredClasses.add(className);
    }

    public void addMonitoredMethod(String className, String methodName, String[] parameterTypes) {
        MethodSignature methodSignature = new MethodSignature(className, methodName, parameterTypes);
        _monitoredMethods.add(methodSignature);
    }

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.SUCCESS);
        }
    }

    @Override
    public void afterThrowing(MethodInvocation methodInvocation, Throwable throwable) throws Throwable {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            serviceRequestDataSample.capture(RequestStatus.ERROR);
        }
    }

    @Override
    public Object before(MethodInvocation methodInvocation) throws Throwable {
        if (!_active) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return null;
        }
        if (!_permissiveMode && !this.isMonitored(methodInvocation)) {
            return null;
        }
        ServiceRequestDataSample serviceRequestDataSample = new ServiceRequestDataSample(methodInvocation);
        serviceRequestDataSample.prepare();
        _serviceRequestDataSampleThreadLocal.set(serviceRequestDataSample);
        DataSampleThreadLocal.initialize();
        return null;
    }

    @Override
    public void duringFinally(MethodInvocation methodInvocation) {
        ServiceRequestDataSample serviceRequestDataSample = _serviceRequestDataSampleThreadLocal.get();
        if (serviceRequestDataSample != null) {
            _serviceRequestDataSampleThreadLocal.remove();
            DataSampleThreadLocal.addDataSample((DataSample)serviceRequestDataSample);
        }
    }

    public Set<String> getMonitoredClasses() {
        return _monitoredClasses;
    }

    public Set<MethodSignature> getMonitoredMethods() {
        return _monitoredMethods;
    }

    public boolean isPermissiveMode() {
        return _permissiveMode;
    }

    public void setActive(boolean active) {
        if (active && !_active) {
            this.serviceBeanAopCacheManager.reset();
        }
        _active = active;
    }

    public void setMonitoredClasses(Set<String> monitoredClasses) {
        _monitoredClasses = monitoredClasses;
    }

    public void setMonitoredMethods(Set<MethodSignature> monitoredMethods) {
        _monitoredMethods = monitoredMethods;
    }

    @Deprecated
    public void setMonitoringDestinationName(String monitoringDestinationName) {
    }

    public void setPermissiveMode(boolean permissiveMode) {
        _permissiveMode = permissiveMode;
    }

    protected boolean isMonitored(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        String className = declaringClass.getName();
        if (_monitoredClasses.contains(className)) {
            return true;
        }
        MethodSignature methodSignature = new MethodSignature(method);
        return _monitoredMethods.contains(methodSignature);
    }

    static {
        _monitoredClasses = new HashSet<String>();
        _monitoredMethods = new HashSet<MethodSignature>();
        _serviceRequestDataSampleThreadLocal = new AutoResetThreadLocal(ServiceRequestDataSample.class + "._serviceRequestDataSampleThreadLocal");
    }
}

