/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.jmx;

import com.liferay.portal.kernel.util.HashUtil;
import java.lang.reflect.Method;

public class MethodSignature {
    private String _className;
    private String _methodName;
    private String[] _parameterTypeNames;

    public MethodSignature(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        this._className = clazz.getName();
        this._methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this._parameterTypeNames = new String[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this._parameterTypeNames[i] = parameterTypes[i].getName();
        }
    }

    public MethodSignature(String className, String methodName, String[] parameterTypeNames) {
        this._className = className;
        this._methodName = methodName;
        this._parameterTypeNames = parameterTypeNames;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)obj;
        if (this._className.equals(methodSignature._className) && this._methodName.equals(methodSignature._methodName) && this._parameterTypeNames.length == methodSignature._parameterTypeNames.length) {
            for (int i = 0; i < this._parameterTypeNames.length; ++i) {
                if (this._parameterTypeNames[i].equals(methodSignature._parameterTypeNames[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this._className;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String[] getParameterTypeNames() {
        return this._parameterTypeNames;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._className);
        hashCode = HashUtil.hash((int)hashCode, (Object)this._methodName);
        for (String parameterTypeName : this._parameterTypeNames) {
            hashCode = HashUtil.hash((int)hashCode, (Object)parameterTypeName);
        }
        return hashCode;
    }
}

