/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutWrapper;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class VirtualLayout
extends LayoutWrapper {
    private static Log _log = LogFactoryUtil.getLog(VirtualLayout.class);
    private Layout _sourceLayout;
    private Group _targetGroup;

    public VirtualLayout(Layout sourceLayout, Group targetGroup) {
        super(sourceLayout);
        this._sourceLayout = sourceLayout;
        this._targetGroup = targetGroup;
    }

    public Object clone() {
        return new VirtualLayout((Layout)this._sourceLayout.clone(), this._targetGroup);
    }

    public String getFriendlyURL() {
        return this.getFriendlyURL(null);
    }

    public String getFriendlyURL(Locale locale) {
        StringBundler sb = new StringBundler(4);
        sb.append("/~");
        try {
            Group group = this._sourceLayout.getGroup();
            sb.append(group.getFriendlyURL());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (locale == null) {
            sb.append(this._sourceLayout.getFriendlyURL());
        } else {
            sb.append(this._sourceLayout.getFriendlyURL(locale));
        }
        return sb.toString();
    }

    public Group getGroup() {
        return this.getHostGroup();
    }

    public long getGroupId() {
        return this.getVirtualGroupId();
    }

    public Group getHostGroup() {
        return this._targetGroup;
    }

    public LayoutSet getLayoutSet() {
        if (this.isPrivateLayout()) {
            return this._targetGroup.getPrivateLayoutSet();
        }
        return this._targetGroup.getPublicLayoutSet();
    }

    public String getRegularURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getRegularURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    public String getResetLayoutURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getResetLayoutURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    public String getResetMaxStateURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getResetMaxStateURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    public long getSourceGroupId() {
        return this._sourceLayout.getGroupId();
    }

    public Layout getSourceLayout() {
        return this._sourceLayout;
    }

    public long getVirtualGroupId() {
        return this._targetGroup.getGroupId();
    }

    protected String injectVirtualGroupURL(String layoutURL, Locale locale) {
        if (this._sourceLayout.isTypeURL()) {
            return layoutURL;
        }
        try {
            Group group = this._sourceLayout.getGroup();
            StringBundler sb = new StringBundler(4);
            if (this._targetGroup.isUser() && this.isPrivateLayout()) {
                layoutURL = layoutURL.replaceFirst(PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING, PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
            }
            int pos = layoutURL.indexOf(group.getFriendlyURL());
            sb.append(layoutURL.substring(0, pos));
            sb.append(this._targetGroup.getFriendlyURL());
            sb.append(this.getFriendlyURL(locale));
            pos = layoutURL.indexOf("?");
            if (pos > 0) {
                sb.append(layoutURL.substring(pos));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

