/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.LayoutTypeController;
import java.util.Map;

public class LayoutTypeImpl
implements LayoutType {
    private static final String _URL = "${liferay:mainPath}/portal/layout?p_l_id=${liferay:plid}&p_v_l_s_g_id=${liferay:pvlsgid}";
    private final Layout _layout;
    private final LayoutTypeController _layoutTypeController;

    public LayoutTypeImpl(Layout layout, LayoutTypeController layoutTypeController) {
        this._layout = layout;
        this._layoutTypeController = layoutTypeController;
    }

    public String[] getConfigurationActionDelete() {
        return this._layoutTypeController.getConfigurationActionDelete();
    }

    public String[] getConfigurationActionUpdate() {
        return this._layoutTypeController.getConfigurationActionUpdate();
    }

    public Layout getLayout() {
        return this._layout;
    }

    public LayoutTypeController getLayoutTypeController() {
        return this._layoutTypeController;
    }

    public UnicodeProperties getTypeSettingsProperties() {
        return this._layout.getTypeSettingsProperties();
    }

    public String getTypeSettingsProperty(String key) {
        return this.getTypeSettingsProperty(key, null);
    }

    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    public String getURL(Map<String, String> variables) {
        String url = this._layoutTypeController.getURL();
        if (Validator.isNull((String)url) || !url.startsWith(_URL)) {
            url = _URL;
        }
        return StringUtil.replace((String)url, (String)"${", (String)"}", variables);
    }

    public boolean isFirstPageable() {
        return this._layoutTypeController.isFirstPageable();
    }

    public boolean isParentable() {
        return this._layoutTypeController.isParentable();
    }

    public boolean isSitemapable() {
        return this._layoutTypeController.isSitemapable();
    }

    public boolean isURLFriendliable() {
        return this._layoutTypeController.isURLFriendliable();
    }

    @Deprecated
    public void setLayout(Layout layout) {
    }

    public void setTypeSettingsProperty(String key, String value) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        typeSettingsProperties.setProperty(key, value);
    }
}

