/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypeController;
import com.liferay.portal.util.PropsUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LayoutTypeControllerImpl
implements LayoutTypeController {
    private String[] _configurationActionDelete;
    private String[] _configurationActionUpdate;
    private String _editPage;
    private boolean _firstPageable;
    private boolean _parentable;
    private boolean _sitemapable;
    private String _type;
    private String _url;
    private boolean _urlFriendliable;
    private String _viewPage;

    public LayoutTypeControllerImpl(String type) {
        this._type = type;
        Filter filter = new Filter(type);
        this._configurationActionDelete = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.delete", filter)));
        this._configurationActionUpdate = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("layout.configuration.action.update", filter)));
        this._editPage = GetterUtil.getString((String)PropsUtil.get("layout.edit.page", filter));
        this._firstPageable = GetterUtil.getBoolean((String)PropsUtil.get("layout.first.pageable", filter));
        this._parentable = GetterUtil.getBoolean((String)PropsUtil.get("layout.parentable", filter), (boolean)true);
        this._sitemapable = GetterUtil.getBoolean((String)PropsUtil.get("layout.sitemapable", filter), (boolean)true);
        this._url = GetterUtil.getString((String)PropsUtil.get("layout.url", filter));
        this._urlFriendliable = GetterUtil.getBoolean((String)PropsUtil.get("layout.url.friendliable", filter), (boolean)true);
        this._viewPage = GetterUtil.getString((String)PropsUtil.get("layout.view.page", filter));
    }

    public String[] getConfigurationActionDelete() {
        return this._configurationActionDelete;
    }

    public String[] getConfigurationActionUpdate() {
        return this._configurationActionUpdate;
    }

    public String getEditPage() {
        return "/html" + this._editPage;
    }

    public String getURL() {
        return this._url;
    }

    public String getViewPath(String portletId, boolean wap) {
        String path = "/html";
        if (wap) {
            path = "/wap";
        }
        path = Validator.isNotNull((String)portletId) ? (this._type.equals("panel") ? path + "/portal/layout/view/panel.jsp" : (this._type.equals("control_panel") ? path + "/portal/layout/view/control_panel.jsp" : path + "/portal/layout/view/portlet.jsp")) : "/html" + this._viewPage;
        return path;
    }

    public boolean includeLayoutContent(HttpServletRequest request, HttpServletResponse response, Layout layout) throws Exception {
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        String path = this.getViewPath(portletId, BrowserSnifferUtil.isWap((HttpServletRequest)request));
        RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        PipingServletResponse pipingServletResponse = new PipingServletResponse(response, (Writer)unsyncStringWriter);
        String contentType = pipingServletResponse.getContentType();
        requestDispatcher.include((ServletRequest)request, (ServletResponse)pipingServletResponse);
        if (contentType != null) {
            response.setContentType(contentType);
        }
        request.setAttribute("LAYOUT_CONTENT", (Object)unsyncStringWriter.getStringBundler());
        return false;
    }

    public boolean isFirstPageable() {
        return this._firstPageable;
    }

    public boolean isParentable() {
        return this._parentable;
    }

    public boolean isSitemapable() {
        return this._sitemapable;
    }

    public boolean isURLFriendliable() {
        return this._urlFriendliable;
    }

    public boolean matches(HttpServletRequest request, String friendlyURL, Layout layout) {
        try {
            Map friendlyURLMap = layout.getFriendlyURLMap();
            Collection values = friendlyURLMap.values();
            return values.contains(friendlyURL);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

