/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.model.impl.LayoutSetBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.IOException;

public class LayoutSetImpl
extends LayoutSetBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(LayoutSetImpl.class);
    private UnicodeProperties _settingsProperties;
    private String _virtualHostname;

    public ColorScheme getColorScheme() {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public long getLayoutSetPrototypeId() throws PortalException {
        String layoutSetPrototypeUuid = this.getLayoutSetPrototypeUuid();
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            return 0L;
        }
        LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototypeByUuidAndCompanyId((String)layoutSetPrototypeUuid, (long)this.getCompanyId());
        return layoutSetPrototype.getLayoutSetPrototypeId();
    }

    public long getLiveLogoId() {
        long logoId = 0L;
        Group group = null;
        try {
            group = this.getGroup();
            if (!group.isStagingGroup()) {
                return logoId;
            }
        }
        catch (Exception e) {
            return logoId;
        }
        Group liveGroup = group.getLiveGroup();
        LayoutSet liveLayoutSet = null;
        liveLayoutSet = this.isPrivateLayout() ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
        return liveLayoutSet.getLogoId();
    }

    public boolean getLogo() {
        return this.getLogoId() > 0L;
    }

    @Override
    public String getSettings() {
        if (this._settingsProperties == null) {
            return super.getSettings();
        }
        return this._settingsProperties.toString();
    }

    public UnicodeProperties getSettingsProperties() {
        if (this._settingsProperties == null) {
            this._settingsProperties = new UnicodeProperties(true);
            try {
                this._settingsProperties.load(super.getSettings());
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
        return this._settingsProperties;
    }

    public String getSettingsProperty(String key) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        return settingsProperties.getProperty(key);
    }

    public Theme getTheme() {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    public String getThemeSetting(String key, String device) {
        UnicodeProperties settingsProperties = this.getSettingsProperties();
        String value = settingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        Theme theme = this.getTheme(device);
        value = theme.getSetting(key);
        return value;
    }

    @Override
    public String getVirtualHostname() {
        if (this._virtualHostname != null) {
            return this._virtualHostname;
        }
        try {
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((long)this.getCompanyId(), (long)this.getLayoutSetId());
            this._virtualHostname = virtualHost == null ? "" : virtualHost.getHostname();
        }
        catch (Exception e) {
            this._virtualHostname = "";
        }
        return this._virtualHostname;
    }

    public ColorScheme getWapColorScheme() {
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public Theme getWapTheme() {
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public boolean isLayoutSetPrototypeLinkActive() {
        return this.isLayoutSetPrototypeLinkEnabled() && Validator.isNotNull((String)this.getLayoutSetPrototypeUuid());
    }

    public boolean isLogo() {
        return this.getLogo();
    }

    @Override
    public void setSettings(String settings) {
        this._settingsProperties = null;
        super.setSettings(settings);
    }

    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        this._settingsProperties = settingsProperties;
        super.setSettings(this._settingsProperties.toString());
    }

    @Override
    public void setVirtualHostname(String virtualHostname) {
        this._virtualHostname = virtualHostname;
    }

    protected Theme getTheme(String device) {
        boolean controlPanel = false;
        try {
            Group group = this.getGroup();
            controlPanel = group.isControlPanel();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (controlPanel) {
            String themeId = PrefsPropsUtil.getString(this.getCompanyId(), "control.panel.layout.regular.theme.id");
            return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)themeId, (!device.equals("regular") ? 1 : 0) != 0);
        }
        if (device.equals("regular")) {
            return this.getTheme();
        }
        return this.getWapTheme();
    }
}

