/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ColorScheme;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.model.LayoutRevision;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.impl.LayoutRevisionBaseImpl;
import com.liferay.portal.model.impl.ThemeSettingImpl;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutRevisionLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class LayoutRevisionImpl
extends LayoutRevisionBaseImpl {
    private UnicodeProperties _typeSettingsProperties;

    public List<LayoutRevision> getChildren() {
        return LayoutRevisionLocalServiceUtil.getChildLayoutRevisions((long)this.getLayoutSetBranchId(), (long)this.getLayoutRevisionId(), (long)this.getPlid());
    }

    public ColorScheme getColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getTheme().getThemeId(), (String)this.getColorSchemeId(), (boolean)false);
    }

    public String getCssText() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getCss();
        }
        return this.getCss();
    }

    public String getHTMLTitle(Locale locale) {
        String localeLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        return this.getHTMLTitle(localeLanguageId);
    }

    public String getHTMLTitle(String localeLanguageId) {
        String htmlTitle = this.getTitle(localeLanguageId);
        if (Validator.isNull((String)htmlTitle)) {
            htmlTitle = this.getName(localeLanguageId);
        }
        return htmlTitle;
    }

    public boolean getIconImage() {
        return this.getIconImageId() > 0L;
    }

    public LayoutBranch getLayoutBranch() throws PortalException {
        return LayoutBranchLocalServiceUtil.getLayoutBranch((long)this.getLayoutBranchId());
    }

    public LayoutSet getLayoutSet() throws PortalException {
        return LayoutSetLocalServiceUtil.getLayoutSet((long)this.getGroupId(), (boolean)this.isPrivateLayout());
    }

    public String getRegularURL(HttpServletRequest request) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        Layout layout = LayoutLocalServiceUtil.getLayout((long)this.getPlid());
        String url = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        if (!CookieKeys.hasSessionId((HttpServletRequest)request) && (url.startsWith(portalURL) || url.startsWith("/"))) {
            url = PortalUtil.getURLWithSessionId((String)url, (String)request.getSession().getId());
        }
        return url;
    }

    public Theme getTheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getThemeId(), (boolean)false);
    }

    public String getThemeSetting(String key, String device) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String value = typeSettingsProperties.getProperty(ThemeSettingImpl.namespaceProperty(device, key));
        if (value != null) {
            return value;
        }
        if (!this.isInheritLookAndFeel()) {
            try {
                Theme theme = this.getTheme(device);
                return theme.getSetting(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            LayoutSet layoutSet = this.getLayoutSet();
            value = layoutSet.getThemeSetting(key, device);
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    @Override
    public String getTypeSettings() {
        if (this._typeSettingsProperties == null) {
            return super.getTypeSettings();
        }
        return this._typeSettingsProperties.toString();
    }

    public UnicodeProperties getTypeSettingsProperties() {
        if (this._typeSettingsProperties == null) {
            this._typeSettingsProperties = new UnicodeProperties(true);
            this._typeSettingsProperties.fastLoad(super.getTypeSettings());
        }
        return this._typeSettingsProperties;
    }

    public String getTypeSettingsProperty(String key) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key);
    }

    public String getTypeSettingsProperty(String key, String defaultValue) {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        return typeSettingsProperties.getProperty(key, defaultValue);
    }

    public ColorScheme getWapColorScheme() throws PortalException {
        if (this.isInheritLookAndFeel()) {
            return this.getLayoutSet().getWapColorScheme();
        }
        return ThemeLocalServiceUtil.getColorScheme((long)this.getCompanyId(), (String)this.getWapTheme().getThemeId(), (String)this.getWapColorSchemeId(), (boolean)true);
    }

    public Theme getWapTheme() throws PortalException {
        if (this.isInheritWapLookAndFeel()) {
            return this.getLayoutSet().getWapTheme();
        }
        return ThemeLocalServiceUtil.getTheme((long)this.getCompanyId(), (String)this.getWapThemeId(), (boolean)true);
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public boolean isContentDisplayPage() {
        UnicodeProperties typeSettingsProperties = this.getTypeSettingsProperties();
        String defaultAssetPublisherPortletId = typeSettingsProperties.getProperty("default-asset-publisher-portlet-id");
        return Validator.isNotNull((String)defaultAssetPublisherPortletId);
    }

    public boolean isIconImage() {
        return this.getIconImage();
    }

    public boolean isInheritLookAndFeel() {
        return Validator.isNull((String)this.getThemeId()) || Validator.isNull((String)this.getColorSchemeId());
    }

    public boolean isInheritWapLookAndFeel() {
        return Validator.isNull((String)this.getWapThemeId()) || Validator.isNull((String)this.getWapColorSchemeId());
    }

    @Override
    public void setTypeSettings(String typeSettings) {
        this._typeSettingsProperties = null;
        super.setTypeSettings(typeSettings);
    }

    public void setTypeSettingsProperties(UnicodeProperties typeSettingsProperties) {
        this._typeSettingsProperties = typeSettingsProperties;
        super.setTypeSettings(this._typeSettingsProperties.toString());
    }

    protected Theme getTheme(String device) throws PortalException {
        if (device.equals("regular")) {
            return this.getTheme();
        }
        return this.getWapTheme();
    }
}

