/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.model.BaseModelListener;
import com.liferay.portal.model.Contact;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPExporterUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import java.util.Map;

public class ContactModelListener
extends BaseModelListener<Contact> {
    public void onAfterCreate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    public void onAfterUpdate(Contact contact) throws ModelListenerException {
        try {
            this.exportToLDAP(contact);
        }
        catch (Exception e) {
            throw new ModelListenerException((Throwable)e);
        }
    }

    protected void exportToLDAP(Contact contact) throws Exception {
        if (LDAPUserTransactionThreadLocal.isOriginatesFromLDAP()) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Map expandoBridgeAttributes = null;
        if (serviceContext != null) {
            expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        }
        PortalLDAPExporterUtil.exportToLDAP((Contact)contact, (Map)expandoBridgeAttributes);
    }
}

