/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup.action.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.action.ActionHandler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseRedirectActionHandler
implements ActionHandler {
    private static Log _log = LogFactoryUtil.getLog(BaseRedirectActionHandler.class);

    public void applyAction(MDRAction mdrAction, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        String url = this.getURL(mdrAction, request, response);
        if (Validator.isNull((String)url)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"URL is null");
            }
            return;
        }
        String requestURL = String.valueOf(request.getRequestURL());
        if (StringUtil.contains((String)requestURL, (String)url)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Skipping redirect. Current URL contains redirect URL.");
            }
            return;
        }
        try {
            response.sendRedirect(url);
        }
        catch (IOException ioe) {
            throw new PortalException("Unable to redirect to " + url, (Throwable)ioe);
        }
    }

    protected abstract String getURL(MDRAction var1, HttpServletRequest var2, HttpServletResponse var3) throws PortalException;
}

