/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.rulegroup;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.rulegroup.ActionHandlerManager;
import com.liferay.portal.kernel.mobile.device.rulegroup.action.ActionHandler;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultActionHandlerManagerImpl
implements ActionHandlerManager {
    private static Log _log = LogFactoryUtil.getLog(DefaultActionHandlerManagerImpl.class);
    private Map<String, ActionHandler> _deviceActionHandlers = new HashMap<String, ActionHandler>();

    public void applyActions(List<MDRAction> mdrActions, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        for (MDRAction mdrAction : mdrActions) {
            this.applyAction(mdrAction, request, response);
        }
    }

    public ActionHandler getActionHandler(String actionType) {
        return this._deviceActionHandlers.get(actionType);
    }

    public Collection<ActionHandler> getActionHandlers() {
        return Collections.unmodifiableCollection(this._deviceActionHandlers.values());
    }

    public Collection<String> getActionHandlerTypes() {
        return this._deviceActionHandlers.keySet();
    }

    public void registerActionHandler(ActionHandler actionHandler) {
        ActionHandler oldActionHandler = this._deviceActionHandlers.put(actionHandler.getType(), actionHandler);
        if (oldActionHandler != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Replacing existing action handler type " + actionHandler.getType()));
        }
    }

    public void setActionHandlers(Collection<ActionHandler> actionHandlers) {
        for (ActionHandler actionHandler : actionHandlers) {
            this.registerActionHandler(actionHandler);
        }
    }

    public ActionHandler unregisterActionHandler(String actionType) {
        return this._deviceActionHandlers.remove(actionType);
    }

    protected void applyAction(MDRAction mdrAction, HttpServletRequest request, HttpServletResponse response) throws PortalException {
        ActionHandler actionHandler = this._deviceActionHandlers.get(mdrAction.getType());
        if (actionHandler != null) {
            actionHandler.applyAction(mdrAction, request, response);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("No action handler registered for type " + mdrAction.getType()));
        }
    }
}

