/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.microsofttranslator;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;

public class MicrosoftTranslatorAuthenticator {
    private static final long _EXPIRE_TIME = 600000L;
    private static final String _URL = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13";
    private static Log _log = LogFactoryUtil.getLog(MicrosoftTranslatorAuthenticator.class);
    private String _accessToken;
    private String _clientId;
    private String _clientSecret;
    private String _error;
    private long _initTime;

    public MicrosoftTranslatorAuthenticator() {
        this.init(true);
    }

    public MicrosoftTranslatorAuthenticator(String clientId, String clientSecret) {
        this._clientId = clientId;
        this._clientSecret = clientSecret;
        this.init(true);
    }

    public String getAccessToken() {
        this.init(false);
        return this._accessToken;
    }

    public String getError() {
        return this._error;
    }

    public void init(boolean manual) {
        if (manual || this.isStale()) {
            this.doInit();
        }
    }

    protected void doInit() {
        block5: {
            if (Validator.isNull((String)this._clientId)) {
                this._clientId = PropsValues.MICROSOFT_TRANSLATOR_CLIENT_ID;
                this._clientSecret = PropsValues.MICROSOFT_TRANSLATOR_CLIENT_SECRET;
            }
            try {
                Http.Options options = new Http.Options();
                StringBundler sb = new StringBundler(5);
                sb.append("grant_type=client_credentials&client_id=");
                sb.append(HttpUtil.encodeURL((String)this._clientId));
                sb.append("&client_secret=");
                sb.append(HttpUtil.encodeURL((String)this._clientSecret));
                sb.append("&scope=http://api.microsofttranslator.com");
                options.setBody(sb.toString(), "application/x-www-form-urlencoded", "UTF-8");
                options.setLocation(_URL);
                options.setPost(true);
                String jsonString = HttpUtil.URLtoString((Http.Options)options);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)jsonString);
                this._error = jsonObject.getString("error_description");
                if (this._error != null && _log.isInfoEnabled()) {
                    _log.info((Object)("Unable to initialize access token: " + this._error));
                }
                this._accessToken = jsonObject.getString("access_token");
                if (this._accessToken != null) {
                    _log.info((Object)("Access token " + this._accessToken));
                }
                this._initTime = System.currentTimeMillis();
            }
            catch (Exception e) {
                if (!_log.isInfoEnabled()) break block5;
                _log.info((Object)"Unable to initialize authentication token", (Throwable)e);
            }
        }
    }

    protected boolean isStale() {
        return this._initTime + 600000L <= System.currentTimeMillis();
    }
}

