/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.layoutconfiguration.util.velocity;

import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.layoutconfiguration.util.velocity.ColumnProcessor;
import com.liferay.portal.model.CustomizedPages;
import com.liferay.portal.model.Layout;
import com.liferay.portlet.layoutsadmin.context.LayoutsAdminDisplayContext;
import com.liferay.portlet.sites.util.SitesUtil;
import com.liferay.taglib.aui.InputTag;
import java.io.Writer;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;

public class CustomizationSettingsProcessor
implements ColumnProcessor {
    private boolean _customizationEnabled;
    private UnicodeProperties _layoutTypeSettings;
    private PageContext _pageContext;
    private Writer _writer;

    public CustomizationSettingsProcessor(HttpServletRequest request, HttpServletResponse response) {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        this._pageContext = jspFactory.getPageContext((Servlet)new JSPSupportServlet(request.getServletContext()), (ServletRequest)request, (ServletResponse)response, null, false, 0, false);
        this._writer = this._pageContext.getOut();
        LayoutsAdminDisplayContext layoutsAdminDisplayContext = new LayoutsAdminDisplayContext(request, null);
        Layout selLayout = layoutsAdminDisplayContext.getSelLayout();
        this._layoutTypeSettings = selLayout.getTypeSettingsProperties();
        this._customizationEnabled = true;
        if (!SitesUtil.isLayoutUpdateable((Layout)selLayout)) {
            this._customizationEnabled = false;
        }
        if (selLayout.isLayoutPrototypeLinkActive()) {
            this._customizationEnabled = false;
        }
    }

    @Override
    public String processColumn(String columnId) throws Exception {
        return this.processColumn(columnId, "");
    }

    @Override
    public String processColumn(String columnId, String classNames) throws Exception {
        String customizableKey = CustomizedPages.namespaceColumnId((String)columnId);
        boolean customizable = false;
        if (this._customizationEnabled) {
            customizable = GetterUtil.getBoolean((String)this._layoutTypeSettings.getProperty(customizableKey, String.valueOf(false)));
        }
        this._writer.append("<div class=\"");
        this._writer.append(classNames);
        this._writer.append("\">");
        this._writer.append("<h1>");
        this._writer.append(columnId);
        this._writer.append("</h1>");
        InputTag inputTag = new InputTag();
        inputTag.setDisabled(!this._customizationEnabled);
        inputTag.setLabel("customizable");
        inputTag.setName("TypeSettingsProperties--".concat(customizableKey).concat("--"));
        inputTag.setPageContext(this._pageContext);
        inputTag.setType("checkbox");
        inputTag.setValue((Object)customizable);
        int result = inputTag.doStartTag();
        if (result == 1) {
            inputTag.doEndTag();
        }
        this._writer.append("</div>");
        return "";
    }

    @Override
    public String processMax() throws Exception {
        return "";
    }

    @Override
    @Deprecated
    public String processMax(String classNames) throws Exception {
        return this.processMax();
    }

    @Override
    public String processPortlet(String portletId) throws Exception {
        this._writer.append("<div class=\"portlet\">");
        this._writer.append(portletId);
        this._writer.append("</div>");
        return "";
    }

    @Override
    public String processPortlet(String portletId, Map<String, ?> defaultSettingsMap) throws Exception {
        return this.processPortlet(portletId);
    }
}

