/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.lar.messaging.BasePublisherMessageListener;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import java.util.Date;
import java.util.Map;

public class LayoutsLocalPublisherMessageListener
extends BasePublisherMessageListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message, MessageStatus messageStatus) throws PortalException {
        long exportImportConfigurationId = GetterUtil.getLong((Object)message.getPayload());
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
        messageStatus.setPayload((Object)exportImportConfiguration);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
        long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
        Map parameterMap = (Map)settingsMap.get("parameterMap");
        DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration, (String)"fromLastPublishDate");
        this.initThreadLocals(userId, parameterMap);
        try {
            if (layoutIds == null) {
                StagingUtil.publishLayouts((long)userId, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (Map)parameterMap, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate());
            } else {
                StagingUtil.publishLayouts((long)userId, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate());
            }
        }
        finally {
            this.resetThreadLocals();
        }
    }
}

