/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.messaging;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.messaging.BaseMessageStatusMessageListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class BasePublisherMessageListener
extends BaseMessageStatusMessageListener {
    protected void initThreadLocals(long userId, Map<String, String[]> parameterMap) throws PortalException {
        User user = UserLocalServiceUtil.getUserById((long)userId);
        CompanyThreadLocal.setCompanyId((Long)user.getCompanyId());
        PrincipalThreadLocal.setName((long)userId);
        PermissionChecker permissionChecker = null;
        try {
            permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(user.getCompanyId());
        serviceContext.setPathMain(PortalUtil.getPathMain());
        serviceContext.setSignedIn(!user.isDefaultUser());
        serviceContext.setUserId(user.getUserId());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String param = entry.getKey();
            Object[] values = entry.getValue();
            if (!ArrayUtil.isNotEmpty((Object[])values)) continue;
            if (values.length == 1) {
                attributes.put(param, values[0]);
                continue;
            }
            attributes.put(param, values);
        }
        serviceContext.setAttributes(attributes);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
    }

    protected void resetThreadLocals() {
        CompanyThreadLocal.setCompanyId((Long)0L);
        PermissionThreadLocal.setPermissionChecker(null);
        PrincipalThreadLocal.setName(null);
        ServiceContextThreadLocal.popServiceContext();
    }
}

