/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.StagingLocalServiceUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionalCallableUtil;
import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class LayoutStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    private static Log _log = LogFactoryUtil.getLog(LayoutStagingBackgroundTaskExecutor.class);
    private TransactionAttribute _transactionAttribute = TransactionAttributeBuilder.build(Propagation.REQUIRED, new Class[]{Exception.class}, new Class[0]);

    public LayoutStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws PortalException {
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long exportImportConfigurationId = MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId");
        ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long userId = MapUtil.getLong((Map)settingsMap, (String)"userId");
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        StagingUtil.lockGroup((long)userId, (long)targetGroupId);
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        this.clearBackgroundTaskStatus(backgroundTask);
        MissingReferences missingReferences = null;
        try {
            LayoutStagingCallable layoutStagingCallable = new LayoutStagingCallable(backgroundTask.getBackgroundTaskId(), exportImportConfiguration, sourceGroupId, targetGroupId, userId);
            missingReferences = TransactionalCallableUtil.call(this._transactionAttribute, layoutStagingCallable);
        }
        catch (Throwable t) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)t, t);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to publish layout: " + t.getMessage()));
            }
            Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
            if (sourceGroup.hasStagingGroup()) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setUserId(userId);
                StagingLocalServiceUtil.disableStaging((Group)sourceGroup, (ServiceContext)serviceContext);
            }
            throw new SystemException(t);
        }
        finally {
            StagingUtil.unlockGroup((long)targetGroupId);
        }
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    protected void initLayoutSetBranches(long userId, long sourceGroupId, long targetGroupId) throws PortalException {
        Group sourceGroup = GroupLocalServiceUtil.getGroup((long)sourceGroupId);
        if (!sourceGroup.hasStagingGroup()) {
            return;
        }
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)false, (boolean)true);
        LayoutSetBranchLocalServiceUtil.deleteLayoutSetBranches((long)targetGroupId, (boolean)true, (boolean)true);
        UnicodeProperties typeSettingsProperties = sourceGroup.getTypeSettingsProperties();
        boolean branchingPrivate = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPrivate"));
        boolean branchingPublic = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("branchingPublic"));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(userId);
        StagingLocalServiceUtil.checkDefaultLayoutSetBranches((long)userId, (Group)sourceGroup, (boolean)branchingPublic, (boolean)branchingPrivate, (boolean)false, (ServiceContext)serviceContext);
    }

    private class LayoutStagingCallable
    implements Callable<MissingReferences> {
        private long _backgroundTaskId;
        private ExportImportConfiguration _exportImportConfiguration;
        private long _sourceGroupId;
        private long _targetGroupId;
        private long _userId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MissingReferences call() throws PortalException {
            MissingReferences missingReferences;
            File file;
            block3: {
                file = null;
                missingReferences = null;
                try {
                    Map settingsMap = this._exportImportConfiguration.getSettingsMap();
                    boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
                    long[] layoutIds = GetterUtil.getLongValues(settingsMap.get("layoutIds"));
                    Map parameterMap = (Map)settingsMap.get("parameterMap");
                    DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)this._exportImportConfiguration, (String)"fromLastPublishDate");
                    file = LayoutLocalServiceUtil.exportLayoutsAsFile((long)this._sourceGroupId, (boolean)privateLayout, (long[])layoutIds, (Map)parameterMap, (Date)dateRange.getStartDate(), (Date)dateRange.getEndDate());
                    LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "exported");
                    missingReferences = LayoutLocalServiceUtil.validateImportLayoutsFile((long)this._userId, (long)this._targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
                    LayoutStagingBackgroundTaskExecutor.this.markBackgroundTask(this._backgroundTaskId, "validated");
                    LayoutLocalServiceUtil.importLayouts((long)this._userId, (long)this._targetGroupId, (boolean)privateLayout, (Map)parameterMap, (File)file);
                    LayoutStagingBackgroundTaskExecutor.this.initLayoutSetBranches(this._userId, this._sourceGroupId, this._targetGroupId);
                    boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
                    if (!updateLastPublishDate) break block3;
                    Group sourceGroup = GroupLocalServiceUtil.getGroup((long)this._sourceGroupId);
                    if (!sourceGroup.hasStagingGroup()) {
                        StagingUtil.updateLastPublishDate((long)this._sourceGroupId, (boolean)privateLayout, (Date)dateRange.getEndDate());
                        break block3;
                    }
                    StagingUtil.updateLastPublishDate((long)this._targetGroupId, (boolean)privateLayout, (Date)dateRange.getEndDate());
                }
                catch (Throwable throwable) {
                    FileUtil.delete(file);
                    throw throwable;
                }
            }
            FileUtil.delete((File)file);
            return missingReferences;
        }

        private LayoutStagingCallable(long backgroundTaskId, ExportImportConfiguration exportImportConfiguration, long sourceGroupId, long targetGroupId, long userId) {
            this._backgroundTaskId = backgroundTaskId;
            this._exportImportConfiguration = exportImportConfiguration;
            this._sourceGroupId = sourceGroupId;
            this._targetGroupId = targetGroupId;
            this._userId = userId;
        }
    }
}

