/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.lar.backgroundtask;

import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RemoteExportException;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportDateUtil;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.DateRange;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.lar.backgroundtask.BaseStagingBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.LayoutStagingBackgroundTaskStatusMessageTranslator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ExportImportConfigurationLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.http.LayoutServiceHttp;
import com.liferay.portal.service.http.StagingServiceHttp;
import com.liferay.portal.util.PropsValues;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LayoutRemoteStagingBackgroundTaskExecutor
extends BaseStagingBackgroundTaskExecutor {
    public LayoutRemoteStagingBackgroundTaskExecutor() {
        this.setBackgroundTaskStatusMessageTranslator(new LayoutStagingBackgroundTaskStatusMessageTranslator());
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws PortalException {
        MissingReferences missingReferences;
        FileInputStream fileInputStream;
        File file;
        long stagingRequestId;
        HttpPrincipal httpPrincipal;
        block9: {
            Map taskContextMap = backgroundTask.getTaskContextMap();
            long exportImportConfigurationId = MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId");
            ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationLocalServiceUtil.getExportImportConfiguration((long)exportImportConfigurationId);
            Map settingsMap = exportImportConfiguration.getSettingsMap();
            long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
            boolean privateLayout = MapUtil.getBoolean((Map)settingsMap, (String)"privateLayout");
            Map layoutIdMap = (Map)settingsMap.get("layoutIdMap");
            Map parameterMap = (Map)settingsMap.get("parameterMap");
            long remoteGroupId = MapUtil.getLong((Map)settingsMap, (String)"remoteGroupId");
            DateRange dateRange = ExportImportDateUtil.getDateRange((ExportImportConfiguration)exportImportConfiguration, (String)"fromLastPublishDate");
            httpPrincipal = (HttpPrincipal)taskContextMap.get("httpPrincipal");
            this.clearBackgroundTaskStatus(backgroundTask);
            stagingRequestId = 0L;
            file = null;
            fileInputStream = null;
            missingReferences = null;
            try {
                file = this.exportLayoutsAsFile(sourceGroupId, privateLayout, layoutIdMap, parameterMap, remoteGroupId, dateRange.getStartDate(), dateRange.getEndDate(), httpPrincipal);
                String checksum = FileUtil.getMD5Checksum((File)file);
                fileInputStream = new FileInputStream(file);
                stagingRequestId = StagingServiceHttp.createStagingRequest(httpPrincipal, remoteGroupId, checksum);
                byte[] bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
                int i = 0;
                int j = 0;
                String numberFormat = String.format("%%0%dd", String.valueOf((int)(file.length() / (long)bytes.length)).length() + 1);
                while ((i = fileInputStream.read(bytes)) >= 0) {
                    String fileName = file.getName() + String.format(numberFormat, j++);
                    if (i < PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE) {
                        byte[] tempBytes = new byte[i];
                        System.arraycopy(bytes, 0, tempBytes, 0, i);
                        StagingServiceHttp.updateStagingRequest(httpPrincipal, stagingRequestId, fileName, tempBytes);
                    } else {
                        StagingServiceHttp.updateStagingRequest(httpPrincipal, stagingRequestId, fileName, bytes);
                    }
                    bytes = new byte[PropsValues.STAGING_REMOTE_TRANSFER_BUFFER_SIZE];
                }
                this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "exported");
                missingReferences = StagingServiceHttp.validateStagingRequest(httpPrincipal, stagingRequestId, privateLayout, parameterMap);
                this.markBackgroundTask(backgroundTask.getBackgroundTaskId(), "validated");
                StagingServiceHttp.publishStagingRequest(httpPrincipal, stagingRequestId, privateLayout, parameterMap);
                boolean updateLastPublishDate = MapUtil.getBoolean((Map)parameterMap, (String)"UPDATE_LAST_PUBLISH_DATE");
                if (!updateLastPublishDate) break block9;
                StagingUtil.updateLastPublishDate((long)sourceGroupId, (boolean)privateLayout, (Date)dateRange.getEndDate());
            }
            catch (IOException ioe) {
                try {
                    throw new SystemException((Throwable)ioe);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
                    FileUtil.delete(file);
                    if (stagingRequestId > 0L) {
                        StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, stagingRequestId);
                    }
                    throw throwable;
                }
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{fileInputStream});
        FileUtil.delete((File)file);
        if (stagingRequestId > 0L) {
            StagingServiceHttp.cleanUpStagingRequest(httpPrincipal, stagingRequestId);
        }
        return this.processMissingReferences(backgroundTask.getBackgroundTaskId(), missingReferences);
    }

    protected File exportLayoutsAsFile(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, long remoteGroupId, Date startDate, Date endDate, HttpPrincipal httpPrincipal) throws PortalException {
        if (layoutIdMap == null || layoutIdMap.isEmpty()) {
            return LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, null, parameterMap, (Date)startDate, (Date)endDate);
        }
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (Map.Entry<Long, Boolean> entry : layoutIdMap.entrySet()) {
            long plid = GetterUtil.getLong((String)String.valueOf(entry.getKey()));
            boolean includeChildren = entry.getValue();
            Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
            if (!layouts.contains(layout)) {
                layouts.add(layout);
            }
            List<Layout> parentLayouts = this.getMissingRemoteParentLayouts(httpPrincipal, layout, remoteGroupId);
            for (Layout parentLayout : parentLayouts) {
                if (layouts.contains(parentLayout)) continue;
                layouts.add(parentLayout);
            }
            if (!includeChildren) continue;
            for (Layout childLayout : layout.getAllChildren()) {
                if (layouts.contains(childLayout)) continue;
                layouts.add(childLayout);
            }
        }
        long[] layoutIds = ExportImportHelperUtil.getLayoutIds(layouts);
        if (layoutIds.length <= 0) {
            throw new RemoteExportException(4);
        }
        return LayoutLocalServiceUtil.exportLayoutsAsFile((long)sourceGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate);
    }

    protected List<Layout> getMissingRemoteParentLayouts(HttpPrincipal httpPrincipal, Layout layout, long remoteGroupId) throws PortalException {
        ArrayList<Layout> missingRemoteParentLayouts = new ArrayList<Layout>();
        long parentLayoutId = layout.getParentLayoutId();
        while (parentLayoutId > 0L) {
            Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
            try {
                LayoutServiceHttp.getLayoutByUuidAndGroupId(httpPrincipal, parentLayout.getUuid(), remoteGroupId, parentLayout.getPrivateLayout());
                break;
            }
            catch (NoSuchLayoutException nsle) {
                missingRemoteParentLayouts.add(parentLayout);
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        return missingRemoteParentLayouts;
    }
}

